/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.AddParameterBindingCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.DeleteParameterBindingCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnExpressionHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationParameterColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextBoxDOMElement;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;

public class InvocationGrid
extends BaseExpressionGrid<Invocation, InvocationGridData, InvocationUIModelMapper>
implements HasListSelectorControl {
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final NameAndDataTypePopoverView.Presenter headerEditor;

    public InvocationGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, InvocationGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, boolean isOnlyVisualChangeAllowed, int nesting, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(parent, nodeUUID, hasExpression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new InvocationGridRenderer(gridData), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, isOnlyVisualChangeAllowed, nesting);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public InvocationUIModelMapper makeUiModelMapper() {
        return new InvocationUIModelMapper((GridWidget)this, () -> ((InvocationGrid)this).getModel(), this.getExpression(), () -> this.isOnlyVisualChangeAllowed, this.expressionEditorDefinitionsSupplier, this.listSelector, this.nesting);
    }

    @Override
    protected void initialiseUiColumns() {
        ArrayList<GridColumn.HeaderMetaData> headerMetaData = new ArrayList<GridColumn.HeaderMetaData>();
        RowNumberColumn rowNumberColumn = new RowNumberColumn();
        rowNumberColumn.setWidth(this.getAndSetInitialWidth(0, rowNumberColumn.getWidth()));
        if (this.nesting == 0) {
            headerMetaData.add(new InvocationColumnHeaderMetaData(this.hasExpression, this.hasName, this.clearDisplayNameConsumer(true), this.setDisplayNameConsumer(true), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("InvocationEditor.EditExpression")), this.listSelector, this::getHeaderItems, this::onItemSelected));
        }
        headerMetaData.add(new InvocationColumnExpressionHeaderMetaData(this::getExpressionText, this::setExpressionText, (SingletonDOMElementFactory<TextBox, TextBoxDOMElement>)this.getHeaderTextBoxFactory(), Optional.of(this.translationService.getTranslation("InvocationEditor.EnterFunction")), this.listSelector, this::getHeaderItems, this::onItemSelected));
        InvocationParameterColumn nameColumn = new InvocationParameterColumn((List<GridColumn.HeaderMetaData>)headerMetaData, this.getAndSetInitialWidth(1, 100.0), this, rowIndex -> true, this.clearDisplayNameConsumer(false), this.setDisplayNameConsumer(false), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("InvocationEditor.EditParameter")));
        ExpressionEditorColumn expressionColumn = new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, headerMetaData, this.getAndSetInitialWidth(2, 150.0), (BaseGrid<? extends Expression>)this);
        this.model.appendColumn((GridColumn)rowNumberColumn);
        this.model.appendColumn((GridColumn)nameColumn);
        this.model.appendColumn((GridColumn)expressionColumn);
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> isSelectionLayer == false || gridColumn.equals((Object)expressionColumn));
    }

    private String getExpressionText() {
        return this.getExpression().get().map(invocation -> (LiteralExpression)invocation.getExpression()).map(LiteralExpression::getText).orElse(new Text()).getValue();
    }

    private void setExpressionText(String text) {
        this.getExpression().get().ifPresent(invocation -> ((LiteralExpression)invocation.getExpression()).getText().setValue(text));
    }

    @Override
    public void initialiseUiRows() {
        this.getExpression().get().ifPresent(invocation -> invocation.getBinding().forEach(binding -> this.model.appendRow((GridRow)new ExpressionEditorGridRow())));
    }

    @Override
    public void initialiseUiCells() {
        this.getExpression().get().ifPresent(invocation -> {
            for (int rowIndex = 0; rowIndex < invocation.getBinding().size(); ++rowIndex) {
                ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, 0);
                ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, 1);
                ((InvocationUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, 2);
            }
        });
    }

    List<HasListSelectorControl.ListSelectorItem> getHeaderItems(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("InvocationEditor.Header", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.InsertParameter", new Object[0]), true, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addParameterBinding(this.model.getRowCount()));
        }));
        return items;
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        boolean isMultiRow = SelectionUtils.isMultiRow(this.model);
        boolean isMultiSelect = SelectionUtils.isMultiSelect(this.model);
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("InvocationEditor.Header", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.InsertParameterAbove", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addParameterBinding(uiRowIndex));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.InsertParameterBelow", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addParameterBinding(uiRowIndex + 1));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("InvocationEditor.DeleteParameter", new Object[0]), !isMultiRow && this.model.getRowCount() > 1, () -> {
            this.cellEditorControls.hide();
            this.deleteParameterBinding(uiRowIndex);
        }));
        if (uiColumnIndex != 2) {
            return items;
        }
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        ExpressionCellValue ecv = (ExpressionCellValue)cell.getValue();
        if (!((Optional)ecv.getValue()).isPresent()) {
            return items;
        }
        BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
        if (grid instanceof UndefinedExpressionGrid) {
            return items;
        }
        items.add(new HasListSelectorControl.ListSelectorDividerItem());
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), !isMultiSelect, () -> {
            this.cellEditorControls.hide();
            this.clearExpressionType(uiRowIndex);
        }));
        return items;
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void addParameterBinding(int index) {
        this.getExpression().get().ifPresent(invocation -> {
            Binding binding = new Binding();
            InformationItem parameter = new InformationItem();
            parameter.setName(new Name());
            binding.setParameter(parameter);
            CommandResult result = this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddParameterBindingCommand((Invocation)invocation, binding, this.model, (GridRow)new ExpressionEditorGridRow(), index, (InvocationUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING)));
            if (!CommandUtils.isError((CommandResult)result)) {
                this.selectCell(index, 1, false, false);
                this.startEditingCell(index, 1);
            }
        });
    }

    void deleteParameterBinding(int index) {
        this.getExpression().get().ifPresent(invocation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteParameterBindingCommand((Invocation)invocation, this.model, index, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    void clearExpressionType(int uiRowIndex) {
        GridCellTuple gc = new GridCellTuple(uiRowIndex, 2, (GridWidget)this);
        this.getExpression().get().ifPresent(invocation -> {
            HasExpression hasExpression = (HasExpression)invocation.getBinding().get(uiRowIndex);
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new ClearExpressionTypeCommand(gc, hasExpression, (InvocationUIModelMapper)this.uiModelMapper, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }));
        });
    }

    @Override
    public void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        if (this.hasAnyHeaderCellSelected() || this.hasMultipleCellsSelected()) {
            super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
            return;
        }
        if (uiColumnIndex == 1 && this.getExpression().get().isPresent()) {
            Invocation invocation = (Invocation)this.getExpression().get().get();
            this.fireDomainObjectSelectionEvent((DomainObject)((Binding)invocation.getBinding().get(uiRowIndex)).getVariable());
            return;
        }
        super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
    }

    @Override
    public void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        DMNModelInstrumentedBase base;
        if (this.nesting == 0 && uiHeaderRowIndex == 0 && (uiHeaderColumnIndex == 1 || uiHeaderColumnIndex == 2) && (base = this.hasExpression.asDMNModelInstrumentedBase()) instanceof DomainObject) {
            this.fireDomainObjectSelectionEvent((DomainObject)base);
            return;
        }
        super.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
    }
}

