/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationColumnCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationRowCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationColumnCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationRowCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGridRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.LiteralExpressionGridRow;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.CellContextUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

public class RelationGrid
extends BaseExpressionGrid<Relation, RelationGridData, RelationUIModelMapper>
implements HasListSelectorControl {
    private final TextAreaSingletonDOMElementFactory factory = this.getBodyTextAreaFactory();
    private final NameAndDataTypePopoverView.Presenter headerEditor;

    public RelationGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, RelationGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, boolean isOnlyVisualChangeAllowed, int nesting, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(parent, nodeUUID, hasExpression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new BaseExpressionGridRenderer(gridData), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, isOnlyVisualChangeAllowed, nesting);
        this.headerEditor = headerEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public RelationUIModelMapper makeUiModelMapper() {
        return new RelationUIModelMapper(() -> ((RelationGrid)this).getModel(), this.getExpression(), this.listSelector);
    }

    @Override
    public void initialiseUiColumns() {
        int uiColumnIndex = 0;
        RowNumberColumn rowNumberColumn = new RowNumberColumn();
        rowNumberColumn.setWidth(this.getAndSetInitialWidth(uiColumnIndex++, rowNumberColumn.getWidth()));
        if (this.getExpression().get().isPresent()) {
            this.model.appendColumn((GridColumn)rowNumberColumn);
            Relation e = (Relation)this.getExpression().get().get();
            for (int index = 0; index < e.getColumn().size(); ++index) {
                RelationColumn relationColumn = this.makeRelationColumn(uiColumnIndex++, (InformationItem)e.getColumn().get(index));
                this.model.appendColumn((GridColumn)relationColumn);
            }
        }
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> true);
    }

    private RelationColumn makeRelationColumn(int index, InformationItem informationItem) {
        RelationColumn relationColumn = new RelationColumn((GridColumn.HeaderMetaData)new RelationColumnHeaderMetaData(informationItem, this.clearDisplayNameConsumer(false), this.setDisplayNameConsumer(false), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("RelationEditor.EditRelation")), this.listSelector, this::getHeaderItems, this::onItemSelected), this.factory, this.getAndSetInitialWidth(index, 100.0), this);
        return relationColumn;
    }

    private GridRow makeRelationRow() {
        return new LiteralExpressionGridRow(RendererUtils.getExpressionTextLineHeight(this.getRenderer().getTheme()));
    }

    @Override
    public void initialiseUiRows() {
        this.getExpression().get().ifPresent(e -> e.getRow().forEach(r -> this.model.appendRow(this.makeRelationRow())));
    }

    @Override
    public void initialiseUiCells() {
        this.getExpression().get().ifPresent(e -> {
            for (int rowIndex = 0; rowIndex < e.getRow().size(); ++rowIndex) {
                int columnIndex = 0;
                ((RelationUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, columnIndex++);
                for (int ii = 0; ii < e.getColumn().size(); ++ii) {
                    ((RelationUIModelMapper)this.uiModelMapper).fromDMNModel(rowIndex, columnIndex++);
                }
            }
        });
    }

    List<HasListSelectorControl.ListSelectorItem> getHeaderItems(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        this.addColumnItems(items, uiHeaderColumnIndex);
        return items;
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        this.addColumnItems(items, uiColumnIndex);
        boolean isMultiRow = SelectionUtils.isMultiRow(this.model);
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("RelationEditor.HeaderRows", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.InsertRowAbove", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addRow(uiRowIndex));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.InsertRowBelow", new Object[0]), !isMultiRow, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addRow(uiRowIndex + 1));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.DeleteRow", new Object[0]), !isMultiRow && this.model.getRowCount() > 1, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.deleteRow(uiRowIndex));
        }));
        return items;
    }

    private void addColumnItems(List<HasListSelectorControl.ListSelectorItem> items, int uiColumnIndex) {
        boolean isMultiColumn = SelectionUtils.isMultiColumn(this.model);
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("RelationEditor.HeaderColumns", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.InsertColumnLeft", new Object[0]), !isMultiColumn && uiColumnIndex > 0, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addColumn(uiColumnIndex));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.InsertColumnRight", new Object[0]), !isMultiColumn && uiColumnIndex > 0, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addColumn(uiColumnIndex + 1));
        }));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("RelationEditor.DeleteColumn", new Object[0]), !isMultiColumn && this.model.getColumnCount() - 1 > 1 && uiColumnIndex > 0, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.deleteColumn(uiColumnIndex));
        }));
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void addColumn(int index) {
        this.getExpression().get().ifPresent(relation -> {
            InformationItem informationItem = new InformationItem();
            informationItem.setName(new Name());
            CommandResult result = this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddRelationColumnCommand((Relation)relation, informationItem, this.model, () -> this.makeRelationColumn(index, informationItem), index, (RelationUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING), () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM)));
            if (!CommandUtils.isError((CommandResult)result)) {
                this.selectHeaderCell(0, index, false, false);
                CellContextUtilities.editSelectedCell((GridWidget)this);
            }
        });
    }

    void deleteColumn(int index) {
        this.getExpression().get().ifPresent(relation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteRelationColumnCommand((Relation)relation, this.model, index, (RelationUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM), () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    void addRow(int index) {
        this.getExpression().get().ifPresent(relation -> {
            GridRow relationRow = this.makeRelationRow();
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddRelationRowCommand((Relation)relation, new org.kie.workbench.common.dmn.api.definition.model.List(), this.model, relationRow, index, (RelationUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING)));
        });
    }

    void deleteRow(int index) {
        this.getExpression().get().ifPresent(relation -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteRelationRowCommand((Relation)relation, this.model, index, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    @Override
    public void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        Relation relation;
        RelationUIModelMapperHelper.RelationSection section;
        if (this.hasAnyHeaderCellSelected() || this.hasMultipleCellsSelected()) {
            super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
            return;
        }
        if (this.getExpression().get().isPresent() && (section = RelationUIModelMapperHelper.getSection(relation = (Relation)this.getExpression().get().get(), uiColumnIndex)) == RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM) {
            int iiIndex = RelationUIModelMapperHelper.getInformationItemIndex(relation, uiColumnIndex);
            Expression relationExpression = (Expression)((org.kie.workbench.common.dmn.api.definition.model.List)relation.getRow().get(uiRowIndex)).getExpression().get(iiIndex);
            if (relationExpression instanceof DomainObject) {
                DomainObject domainObject = (DomainObject)relationExpression;
                this.fireDomainObjectSelectionEvent(domainObject);
                return;
            }
        }
        super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
    }

    @Override
    public void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        Relation relation;
        RelationUIModelMapperHelper.RelationSection section;
        if (this.getExpression().get().isPresent() && (section = RelationUIModelMapperHelper.getSection(relation = (Relation)this.getExpression().get().get(), uiHeaderColumnIndex)) == RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM) {
            int iiIndex = RelationUIModelMapperHelper.getInformationItemIndex(relation, uiHeaderColumnIndex);
            InformationItem domainObject = (InformationItem)relation.getColumn().get(iiIndex);
            this.fireDomainObjectSelectionEvent((DomainObject)domainObject);
            return;
        }
        super.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
    }
}

