/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.selector.UndefinedExpressionSelectorPopoverView;

@ApplicationScoped
public class UndefinedExpressionSelectorPopoverImpl
implements UndefinedExpressionSelectorPopoverView.Presenter {
    private UndefinedExpressionSelectorPopoverView view;
    private Optional<UndefinedExpressionGrid> binding = Optional.empty();

    public UndefinedExpressionSelectorPopoverImpl() {
    }

    @Inject
    public UndefinedExpressionSelectorPopoverImpl(UndefinedExpressionSelectorPopoverView view, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier) {
        this.view = view;
        view.init(this);
        view.setExpressionEditorDefinitions(expressionEditorDefinitionsSupplier.get().stream().filter(ExpressionEditorDefinition::isUserSelectable).filter(definition -> definition.getModelClass().isPresent()).collect(Collectors.toList()));
    }

    @Override
    public void onExpressionEditorDefinitionSelected(ExpressionEditorDefinition definition) {
        this.binding.ifPresent(b -> {
            b.onExpressionTypeChanged(definition.getType());
            this.view.hide();
        });
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void bind(UndefinedExpressionGrid bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.binding.ifPresent(b -> this.view.show(editorTitle));
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }
}

