/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.Map;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.NamespaceHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

public class DefinitionsHandler {
    private final IncludedModelsPageStateProviderImpl stateProvider;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public DefinitionsHandler(IncludedModelsPageStateProviderImpl stateProvider, DMNGraphUtils dmnGraphUtils) {
        this.stateProvider = stateProvider;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public void destroy(BaseIncludedModelActiveRecord includedModel) {
        NamespaceHandler.removeIncludedNamespace(this.getNsContext(), includedModel.getNamespace());
    }

    public void create(BaseIncludedModelActiveRecord includedModel) {
        NamespaceHandler.addIncludedNamespace(this.getNsContext(), includedModel.getNamespace());
    }

    private Map<String, String> getNsContext() {
        return this.stateProvider.getDiagram().map(this.dmnGraphUtils::getDefinitions).map(DMNModelInstrumentedBase::getNsContext).orElseThrow(UnsupportedOperationException::new);
    }
}

