/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.search.DMNSubIndex;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class DMNGraphSubIndex
implements DMNSubIndex {
    private final DMNGraphUtils graphUtils;
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;
    private final Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    private final Event<CanvasClearSelectionEvent> canvasClearSelectionEventEvent;
    private final Event<DomainObjectSelectionEvent> domainObjectSelectionEvent;

    @Inject
    public DMNGraphSubIndex(DMNGraphUtils graphUtils, Event<CanvasSelectionEvent> canvasSelectionEvent, Event<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent, Event<CanvasClearSelectionEvent> canvasClearSelectionEventEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent) {
        this.graphUtils = graphUtils;
        this.canvasSelectionEvent = canvasSelectionEvent;
        this.canvasFocusedSelectionEvent = canvasFocusedSelectionEvent;
        this.canvasClearSelectionEventEvent = canvasClearSelectionEventEvent;
        this.domainObjectSelectionEvent = domainObjectSelectionEvent;
    }

    public List<DMNSearchableElement> getSearchableElements() {
        return this.graphUtils.getNodeStream().map(this::makeElement).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private DMNSearchableElement makeElement(Node node) {
        return this.getText(node).map(text -> {
            DMNSearchableElement element = new DMNSearchableElement();
            element.setText((String)text);
            element.setOnFound(this.makeOnFound(node.getUUID()));
            return element;
        }).orElse(null);
    }

    private Optional<String> getText(Node node) {
        Object content = node.getContent();
        if (content instanceof Definition) {
            Object definition = ((Definition)content).getDefinition();
            if (definition instanceof DRGElement) {
                DRGElement drgElement = (DRGElement)definition;
                return Optional.of(drgElement.getName().getValue());
            }
            if (definition instanceof TextAnnotation) {
                TextAnnotation textAnnotation = (TextAnnotation)definition;
                return Optional.of(textAnnotation.getText().getValue());
            }
        }
        return Optional.empty();
    }

    private Command makeOnFound(String uuid) {
        return () -> this.getCanvasHandler().ifPresent(canvasHandler -> {
            this.canvasSelectionEvent.fire((Object)new CanvasSelectionEvent(canvasHandler, uuid));
            this.canvasFocusedSelectionEvent.fire((Object)new CanvasFocusedShapeEvent(canvasHandler, uuid));
        });
    }

    private Optional<CanvasHandler> getCanvasHandler() {
        return Optional.ofNullable(this.graphUtils.getCanvasHandler());
    }

    @Override
    public void onNoResultsFound() {
        this.getCanvasHandler().ifPresent(canvasHandler -> {
            this.canvasClearSelectionEventEvent.fire((Object)new CanvasClearSelectionEvent(canvasHandler));
            this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler, (DomainObject)new NOPDomainObject()));
        });
    }
}

