/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridHelper;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.search.DMNSubIndex;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@ApplicationScoped
public class DMNGridSubIndex
implements DMNSubIndex {
    private final DMNGridHelper dmnGridHelper;

    @Inject
    public DMNGridSubIndex(DMNGridHelper dmnGridHelper) {
        this.dmnGridHelper = dmnGridHelper;
    }

    public List<DMNSearchableElement> getSearchableElements() {
        return this.dmnGridHelper.getGridWidgets().stream().flatMap(gridWidget -> this.getSearchableElements((GridWidget)gridWidget).stream()).collect(Collectors.toList());
    }

    @Override
    public void onSearchClosed() {
        this.dmnGridHelper.focusGridPanel();
    }

    private List<DMNSearchableElement> getSearchableElements(GridWidget gridWidget) {
        ArrayList<DMNSearchableElement> elements = new ArrayList<DMNSearchableElement>();
        GridData model = gridWidget.getModel();
        int rowCount = model.getRowCount();
        int columnCount = model.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                Optional<GridCell<?>> cell = this.getCell(model, row, column);
                if (!cell.isPresent()) continue;
                elements.add(this.makeElement(gridWidget, cell.get(), row, column));
            }
        }
        return elements;
    }

    private Optional<? extends GridCell<?>> getCell(GridData model, int row, int column) {
        return Optional.ofNullable(model.getCell(row, column));
    }

    private DMNSearchableElement makeElement(GridWidget gridWidget, GridCell<?> cell, int row, int column) {
        DMNSearchableElement searchableCell = new DMNSearchableElement();
        String value = this.getValue(cell);
        searchableCell.setText(value);
        searchableCell.setOnFound(() -> this.dmnGridHelper.highlightCell(row, column, gridWidget));
        return searchableCell;
    }

    String getValue(GridCell<?> cell) {
        GridCellValue cellValue = cell.getValue();
        if (cellValue != null) {
            Object value = cellValue.getValue();
            if (value instanceof InformationItemCell.HasNameAndDataTypeCell) {
                InformationItemCell.HasNameAndDataTypeCell hasName = (InformationItemCell.HasNameAndDataTypeCell)value;
                return hasName.hasData() ? hasName.getName().getValue() : "";
            }
            if (value instanceof String || value instanceof Integer) {
                return String.valueOf(value);
            }
        }
        return "";
    }

    @Override
    public void onNoResultsFound() {
        this.dmnGridHelper.clearSelections();
    }
}

