/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeStackHash;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeList {
    private final View view;
    private final ManagedInstance<DataTypeListItem> listItems;
    private final DataTypeManager dataTypeManager;
    private final DataTypeSearchBar searchBar;
    private final DataTypeStackHash dataTypeStackHash;
    private Consumer<DataTypeListItem> onDataTypeListItemUpdate = e -> {};
    private List<DataTypeListItem> items;
    private DataTypeListItem currentEditingItem;

    @Inject
    public DataTypeList(View view, ManagedInstance<DataTypeListItem> listItems, DataTypeManager dataTypeManager, DataTypeSearchBar searchBar, DataTypeStackHash dataTypeStackHash) {
        this.view = view;
        this.listItems = listItems;
        this.dataTypeManager = dataTypeManager;
        this.searchBar = searchBar;
        this.dataTypeStackHash = dataTypeStackHash;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setupItems(List<DataType> dataTypes) {
        this.setListItems(this.makeDataTypeListItems(dataTypes));
        this.setupViewItems();
        this.collapseItemsInTheFirstLevel();
    }

    List<DataTypeListItem> makeDataTypeListItems(List<DataType> dataTypes) {
        ArrayList<DataTypeListItem> listItems = new ArrayList<DataTypeListItem>();
        dataTypes.forEach(dt -> listItems.addAll(this.makeTreeListItems((DataType)dt, 1)));
        return listItems;
    }

    void refreshSubItemsFromListItem(DataTypeListItem listItem, List<DataType> subDataTypes) {
        DataType dataType = listItem.getDataType();
        int level = listItem.getLevel();
        ArrayList<DataTypeListItem> listItems = new ArrayList<DataTypeListItem>();
        for (DataType subDataType : subDataTypes) {
            listItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        this.cleanAndUnIndex(dataType);
        this.addNewSubItems(dataType, listItems);
        listItems.forEach(this::reIndexDataTypes);
        this.getItems().addAll(listItems);
    }

    private void reIndexDataTypes(DataTypeListItem listItem) {
        this.dataTypeManager.from(listItem.getDataType()).withIndexedItemDefinition();
    }

    private void addNewSubItems(DataType dataType, List<DataTypeListItem> gridItems) {
        this.view.addSubItems(dataType, gridItems);
    }

    private void cleanAndUnIndex(DataType dataType) {
        this.view.cleanSubTypes(dataType);
    }

    List<DataTypeListItem> makeTreeListItems(DataType dataType, int level) {
        DataTypeListItem listItem = this.makeListItem();
        List<DataType> subDataTypes = dataType.getSubDataTypes();
        ArrayList<DataTypeListItem> gridItems = new ArrayList<DataTypeListItem>();
        listItem.setupDataType(dataType, level);
        gridItems.add(listItem);
        for (DataType subDataType : subDataTypes) {
            gridItems.addAll(this.makeTreeListItems(subDataType, level + 1));
        }
        return gridItems;
    }

    DataTypeListItem makeListItem() {
        DataTypeListItem listItem = (DataTypeListItem)this.listItems.get();
        listItem.init(this);
        return listItem;
    }

    void removeItem(DataType dataType) {
        this.removeItem(dataType.getUUID());
        this.view.removeItem(dataType);
    }

    void removeItem(String uuid) {
        this.getItems().removeIf(listItem -> Objects.equals(uuid, listItem.getDataType().getUUID()));
    }

    void refreshItemsByUpdatedDataTypes(List<DataType> updateDataTypes) {
        for (DataType dataType : updateDataTypes) {
            this.findItem(dataType).ifPresent(listItem -> {
                listItem.refresh();
                this.refreshSubItemsFromListItem((DataTypeListItem)listItem, dataType.getSubDataTypes());
            });
        }
        this.searchBar.refresh();
    }

    Optional<DataTypeListItem> findItem(DataType dataType) {
        return this.getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), dataType.getUUID())).findFirst();
    }

    void setupViewItems() {
        this.view.setupListItems(this.getItems());
        this.view.showReadOnlyMessage(this.hasReadOnlyDataTypes());
    }

    private boolean hasReadOnlyDataTypes() {
        return this.getItems().stream().anyMatch(DataTypeListItem::isReadOnly);
    }

    public List<DataTypeListItem> getItems() {
        return this.items;
    }

    void setListItems(List<DataTypeListItem> items) {
        this.items = items;
    }

    void collapseItemsInTheFirstLevel() {
        this.getItems().stream().filter(typeListItem -> typeListItem.getLevel() == 1).forEach(DataTypeListItem::collapse);
    }

    void addDataType() {
        DataType dataType = this.dataTypeManager.fromNew().get();
        DataTypeListItem listItem = this.makeListItem(dataType);
        dataType.create();
        this.searchBar.reset();
        this.view.addSubItem(listItem);
        listItem.enableEditMode();
        this.fireOnDataTypeListItemUpdateCallback(listItem);
    }

    void insertBelow(DataType dataType, DataType reference) {
        this.view.insertBelow(this.makeListItem(dataType), reference);
    }

    void insertAbove(DataType dataType, DataType reference) {
        this.view.insertAbove(this.makeListItem(dataType), reference);
    }

    public void showNoDataTypesFound() {
        this.view.showNoDataTypesFound();
    }

    public void showListItems() {
        this.view.showOrHideNoCustomItemsMessage();
    }

    public HTMLElement getListItemsElement() {
        return this.view.getListItems();
    }

    DataTypeListItem makeListItem(DataType dataType) {
        DataTypeListItem listItem = this.makeListItem();
        listItem.setupDataType(dataType, 1);
        this.getItems().add(listItem);
        return listItem;
    }

    void expandAll() {
        if (!this.getSearchBar().isEnabled()) {
            this.getItems().forEach(DataTypeListItem::expand);
        }
    }

    void collapseAll() {
        if (!this.getSearchBar().isEnabled()) {
            this.getItems().forEach(DataTypeListItem::collapse);
        }
    }

    DataTypeSearchBar getSearchBar() {
        return this.searchBar;
    }

    public void enableEditMode(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(DataTypeListItem::enableEditMode);
    }

    public void registerDataTypeListItemUpdateCallback(Consumer<DataTypeListItem> onDataTypeListItemUpdate) {
        this.onDataTypeListItemUpdate = onDataTypeListItemUpdate;
    }

    void insertNestedField(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(DataTypeListItem::insertNestedField);
    }

    void fireOnDataTypeListItemUpdateCallback(String dataTypeHash) {
        this.findItemByDataTypeHash(dataTypeHash).ifPresent(this::fireOnDataTypeListItemUpdateCallback);
    }

    private void fireOnDataTypeListItemUpdateCallback(DataTypeListItem listItem) {
        this.onDataTypeListItemUpdate.accept(listItem);
    }

    Optional<DataTypeListItem> findItemByDataTypeHash(String dataTypeHash) {
        return this.getItems().stream().filter(item -> Objects.equals(this.calculateHash(item.getDataType()), dataTypeHash)).findFirst();
    }

    String calculateParentHash(DataType dataType) {
        return this.dataTypeStackHash.calculateParentHash(dataType);
    }

    String calculateHash(DataType dataType) {
        return this.dataTypeStackHash.calculateHash(dataType);
    }

    public void onDataTypeEditModeToggle(@Observes DataTypeEditModeToggleEvent event) {
        if (event.isEditModeEnabled()) {
            if (this.getCurrentEditingItem() != null && this.getItems().contains(this.getCurrentEditingItem())) {
                this.getCurrentEditingItem().disableEditMode();
            }
            this.setCurrentEditingItem(event.getItem());
        } else if (Objects.equals(event.getItem(), this.getCurrentEditingItem())) {
            this.setCurrentEditingItem(null);
        }
    }

    DataTypeListItem getCurrentEditingItem() {
        return this.currentEditingItem;
    }

    void setCurrentEditingItem(DataTypeListItem currentEditingItem) {
        this.currentEditingItem = currentEditingItem;
    }

    public static interface View
    extends UberElemental<DataTypeList>,
    IsElement {
        public void setupListItems(List<DataTypeListItem> var1);

        public void showOrHideNoCustomItemsMessage();

        public void addSubItems(DataType var1, List<DataTypeListItem> var2);

        public void addSubItem(DataTypeListItem var1);

        public void removeItem(DataType var1);

        public void cleanSubTypes(DataType var1);

        public void insertBelow(DataTypeListItem var1, DataType var2);

        public void insertAbove(DataTypeListItem var1, DataType var2);

        public void showNoDataTypesFound();

        public HTMLDivElement getListItems();

        public void showReadOnlyMessage(boolean var1);
    }
}

