/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryTooltip;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@Dependent
public class DataTypeConstraintView
implements DataTypeConstraint.View {
    @DataField(value="constraints-anchor")
    private final HTMLAnchorElement constraintsAnchor;
    @DataField(value="constraints-tooltip")
    private final HTMLElement constraintsTooltip;
    @DataField(value="constraints-label")
    private final HTMLElement constraintsLabel;
    @DataField(value="constraints-text")
    private final HTMLDivElement constraintsText;
    private final TranslationService translationService;
    private DataTypeConstraint presenter;

    @Inject
    public DataTypeConstraintView(HTMLAnchorElement constraintsAnchor, @Named(value="span") HTMLElement constraintsTooltip, @Named(value="span") HTMLElement constraintsLabel, HTMLDivElement constraintsText, TranslationService translationService) {
        this.constraintsAnchor = constraintsAnchor;
        this.constraintsTooltip = constraintsTooltip;
        this.constraintsLabel = constraintsLabel;
        this.constraintsText = constraintsText;
        this.translationService = translationService;
    }

    public void init(DataTypeConstraint presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.constraintsTooltip.setAttribute("title", this.translationService.format("DataTypeConstraintView.ConstraintsTooltip", new Object[0]));
        this.setupTooltip(this.properties().getJavaScriptObject());
    }

    @EventHandler(value={"constraints-anchor"})
    public void onConstraintsClick(ClickEvent e) {
        this.presenter.openModal();
    }

    @Override
    public void showAnchor() {
        HiddenHelper.show((Element)this.constraintsAnchor);
        HiddenHelper.show((Element)this.constraintsTooltip);
    }

    @Override
    public void showTextLabel() {
        HiddenHelper.show((Element)this.constraintsLabel);
    }

    @Override
    public void hideAnchor() {
        HiddenHelper.hide((Element)this.constraintsAnchor);
        HiddenHelper.hide((Element)this.constraintsTooltip);
    }

    @Override
    public void hideTextLabel() {
        HiddenHelper.hide((Element)this.constraintsLabel);
    }

    @Override
    public void showText() {
        HiddenHelper.show((Element)this.constraintsText);
    }

    @Override
    public void hideText() {
        HiddenHelper.hide((Element)this.constraintsText);
    }

    @Override
    public void setText(String text) {
        boolean isValueBlank = StringUtils.isEmpty((String)text);
        String noneCSSClass = "none";
        if (isValueBlank) {
            this.constraintsText.textContent = "NONE";
            this.constraintsText.classList.add(new String[]{"none"});
        } else {
            this.constraintsText.classList.remove(new String[]{"none"});
            this.constraintsText.textContent = text;
        }
    }

    @Override
    public void enable() {
        HiddenHelper.show((Element)this.getElement());
    }

    @Override
    public void disable() {
        HiddenHelper.hide((Element)this.getElement());
    }

    void setupTooltip(JavaScriptObject javaScriptObject) {
        JQueryTooltip.$((Element)this.constraintsTooltip).tooltip(javaScriptObject);
    }

    JSONObject properties() {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("container", (JSONValue)new JSONString("body"));
        return jsonObject;
    }

    JSONObject makeJsonObject() {
        return new JSONObject();
    }
}

