/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Event;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLElement;
import java.util.Objects;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePicker;
import org.uberfire.client.views.pfly.widgets.Moment;

@Templated
@Dependent
public class TimePickerView
implements TimePicker.View {
    @DataField(value="increase-hours")
    private final HTMLAnchorElement increaseHours;
    @DataField(value="decrease-hours")
    private final HTMLAnchorElement decreaseHours;
    @DataField(value="increase-minutes")
    private final HTMLAnchorElement increaseMinutes;
    @DataField(value="decrease-minutes")
    private final HTMLAnchorElement decreaseMinutes;
    @DataField(value="increase-seconds")
    private final HTMLAnchorElement increaseSeconds;
    @DataField(value="decrease-seconds")
    private final HTMLAnchorElement decreaseSeconds;
    @DataField(value="hours")
    private final HTMLElement hours;
    @DataField(value="minutes")
    private final HTMLElement minutes;
    @DataField(value="seconds")
    private final HTMLElement seconds;
    private TimePickerView presenter;
    private Moment date;
    private Consumer<Moment> onDateChanged;
    private Consumer<Event> onBlur;

    @Inject
    public TimePickerView(HTMLAnchorElement increaseHours, HTMLAnchorElement decreaseHours, HTMLAnchorElement increaseMinutes, HTMLAnchorElement decreaseMinutes, HTMLAnchorElement increaseSeconds, HTMLAnchorElement decreaseSeconds, @Named(value="span") HTMLElement hours, @Named(value="span") HTMLElement minutes, @Named(value="span") HTMLElement seconds) {
        this.increaseHours = increaseHours;
        this.decreaseHours = decreaseHours;
        this.increaseMinutes = increaseMinutes;
        this.decreaseMinutes = decreaseMinutes;
        this.increaseSeconds = increaseSeconds;
        this.decreaseSeconds = decreaseSeconds;
        this.minutes = minutes;
        this.hours = hours;
        this.seconds = seconds;
    }

    public void init(TimePickerView presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDate(Moment moment) {
        this.date = moment;
        this.refresh();
    }

    void refresh() {
        this.setHours(this.getDate().hours());
        this.setMinutes(this.getDate().minutes());
        this.setSeconds(this.getDate().seconds());
        if (!Objects.isNull(this.onDateChanged)) {
            this.onDateChanged.accept(this.getDate());
        }
    }

    void setHours(double hours) {
        this.hours.textContent = this.format(hours);
    }

    void setMinutes(double minutes) {
        this.minutes.textContent = this.format(minutes);
    }

    void setSeconds(double seconds) {
        this.seconds.textContent = this.format(seconds);
    }

    String format(double value) {
        String str = String.valueOf((int)value);
        str = str.length() < 2 ? "0" + str : str;
        return str;
    }

    @EventHandler(value={"increase-hours"})
    public void onIncreaseHoursClick(ClickEvent event) {
        this.getDate().hours(this.getDate().hours() + 1);
        this.refresh();
    }

    @EventHandler(value={"decrease-hours"})
    public void onDecreaseHoursClick(ClickEvent event) {
        this.getDate().hours(this.getDate().hours() - 1);
        this.refresh();
    }

    @EventHandler(value={"increase-minutes"})
    public void onIncreaseMinutesClick(ClickEvent event) {
        int currentHours = this.getDate().hours();
        this.getDate().minutes(this.getDate().minutes() + 1);
        this.getDate().hours(currentHours);
        this.refresh();
    }

    @EventHandler(value={"decrease-minutes"})
    public void onDecreaseMinutesClick(ClickEvent event) {
        int currentHours = this.getDate().hours();
        this.getDate().minutes(this.getDate().minutes() - 1);
        this.getDate().hours(currentHours);
        this.refresh();
    }

    @EventHandler(value={"increase-seconds"})
    public void onIncreaseSecondsClick(ClickEvent event) {
        this.updateSeconds(this.getDate().seconds() + 1);
    }

    @EventHandler(value={"decrease-seconds"})
    public void onDecreaseSecondsClick(ClickEvent event) {
        this.updateSeconds(this.getDate().seconds() - 1);
    }

    void updateSeconds(int seconds) {
        int currentHours = this.getDate().hours();
        int currentMinutes = this.getDate().minutes();
        this.getDate().seconds(seconds);
        this.getDate().minutes(currentMinutes);
        this.getDate().hours(currentHours);
        this.refresh();
    }

    @Override
    public void setOnDateChanged(Consumer<Moment> onDateChanged) {
        this.onDateChanged = onDateChanged;
    }

    @Override
    public Moment getDate() {
        return this.date;
    }

    @Override
    public void setOnBlur(Consumer<Event> onBlur) {
        this.onBlur = onBlur;
        this.getElement().onblur = this::onBlur;
        this.increaseHours.onblur = this::onBlur;
        this.decreaseHours.onblur = this::onBlur;
        this.increaseMinutes.onblur = this::onBlur;
        this.decreaseMinutes.onblur = this::onBlur;
        this.increaseSeconds.onblur = this::onBlur;
        this.decreaseSeconds.onblur = this::onBlur;
    }

    private Object onBlur(Event event) {
        if (!Objects.isNull(this.onBlur)) {
            this.onBlur.accept(event);
        }
        return this;
    }
}

