/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.NodeList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@ApplicationScoped
public class DataTypeSearchBarView
implements DataTypeSearchBar.View {
    static final String RESULT_ENTRY_CSS_CLASS = "kie-search-engine-result";
    static final String ENABLED_SEARCH = "kie-search-engine-enabled";
    @DataField(value="search-bar")
    private final HTMLInputElement searchBar;
    @DataField(value="search-icon")
    private final HTMLElement searchIcon;
    @DataField(value="close-search")
    private final HTMLButtonElement closeSearch;
    private final TranslationService translationService;
    private DataTypeSearchBar presenter;

    @Inject
    public DataTypeSearchBarView(HTMLInputElement searchBar, @Named(value="span") HTMLElement searchIcon, HTMLButtonElement closeSearch, TranslationService translationService) {
        this.searchBar = searchBar;
        this.searchIcon = searchIcon;
        this.closeSearch = closeSearch;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setupSearchBar() {
        this.searchBar.placeholder = this.translationService.format("DataTypeSearchBarView.Search", new Object[0]);
    }

    public void init(DataTypeSearchBar presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"close-search"})
    public void onSearchBarCloseButton(ClickEvent e) {
        this.presenter.reset();
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarKeyUpEvent(KeyUpEvent event) {
        if (this.isEscape(event)) {
            this.presenter.reset();
        } else {
            this.search();
        }
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarKeyDownEvent(KeyDownEvent e) {
        this.refreshSearchBarState();
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarChangeEvent(ChangeEvent e) {
        this.refreshSearchBarState();
    }

    @Override
    public void showSearchResults(List<DataType> results) {
        this.enableSearch();
        this.disableResults();
        results.forEach(dataType -> this.getResultEntry((DataType)dataType).ifPresent(e -> e.classList.add(new String[]{RESULT_ENTRY_CSS_CLASS})));
    }

    @Override
    public void resetSearchBar() {
        this.searchBar.value = "";
        this.refreshSearchBarState();
        this.disableSearch();
        this.disableResults();
    }

    void enableSearch() {
        this.getResultsContainer().classList.add(new String[]{ENABLED_SEARCH});
    }

    void disableSearch() {
        this.getResultsContainer().classList.remove(new String[]{ENABLED_SEARCH});
    }

    void search() {
        String currentValue = this.searchBar.value;
        this.setTimeout(type -> {
            if (Objects.equals(this.searchBar.value, currentValue)) {
                this.presenter.search(currentValue);
            }
        }, 500.0);
    }

    void disableResults() {
        NodeList results = this.getResultsContainer().querySelectorAll(".kie-search-engine-result");
        int i = 0;
        while ((double)i < results.length) {
            ((Element)results.getAt((int)i)).classList.remove(new String[]{RESULT_ENTRY_CSS_CLASS});
            ++i;
        }
    }

    void refreshSearchBarState() {
        boolean isActive = !StringUtils.isEmpty((String)this.searchBar.value);
        this.searchBarActive(isActive);
    }

    private void searchBarActive(boolean isActive) {
        if (isActive) {
            HiddenHelper.hide((Element)this.searchIcon);
            HiddenHelper.show((Element)this.closeSearch);
        } else {
            HiddenHelper.show((Element)this.searchIcon);
            HiddenHelper.hide((Element)this.closeSearch);
        }
    }

    Optional<Element> getResultEntry(DataType dataType) {
        Element entry = this.getResultsContainer().querySelector("[data-row-uuid=\"" + dataType.getUUID() + "\"]");
        return Optional.ofNullable(entry);
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, double delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }

    private boolean isEscape(KeyUpEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 27);
    }

    private Element getResultsContainer() {
        return this.presenter.getResultsContainer();
    }
}

