/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import elemental2.dom.Element;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.uberfire.client.mvp.HasPresenter;

public class DataTypeListShortcuts {
    private DataTypeList dataTypeList;
    private View view;

    @Inject
    public DataTypeListShortcuts(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
        this.dataTypeList.registerDataTypeListItemUpdateCallback(this::onDataTypeListItemUpdate);
    }

    void onArrowDown() {
        this.view.getNextDataTypeRow().ifPresent(this.view::highlight);
    }

    void onArrowUp() {
        this.view.getPrevDataTypeRow().ifPresent(this.view::highlight);
    }

    void onTab() {
        this.view.getFirstDataTypeRow().ifPresent(this.view::highlight);
    }

    void onArrowLeft() {
        this.getCurrentDataTypeListItem().ifPresent(DataTypeListItem::collapse);
    }

    void onArrowRight() {
        this.getCurrentDataTypeListItem().ifPresent(DataTypeListItem::expand);
    }

    void onCtrlE() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::enableEditMode);
    }

    void onEscape() {
        Optional<DataTypeListItem> currentDataTypeListItem = this.getCurrentDataTypeListItem();
        if (currentDataTypeListItem.isPresent()) {
            currentDataTypeListItem.get().disableEditMode();
        } else {
            this.getVisibleDataTypeListItems().forEach(DataTypeListItem::disableEditMode);
            this.reset();
        }
    }

    void onCtrlBackspace() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::remove);
    }

    void onCtrlS() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::saveAndCloseEditMode);
    }

    void onCtrlB() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::insertNestedField);
    }

    void onCtrlU() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::insertFieldAbove);
    }

    void onCtrlD() {
        this.consumeIfDataTypeIsNotReadOnly(DataTypeListItem::insertFieldBelow);
    }

    DataTypeList getDataTypeList() {
        return this.dataTypeList;
    }

    private List<DataTypeListItem> getVisibleDataTypeListItems() {
        return this.view.getVisibleDataTypeListItems();
    }

    private Optional<DataTypeListItem> getCurrentDataTypeListItem() {
        return this.view.getCurrentDataTypeListItem();
    }

    void focusIn() {
        this.view.focusIn();
    }

    public void highlight(Element dataTypeElement) {
        this.view.highlight(dataTypeElement);
    }

    public void reset() {
        this.view.reset();
    }

    private void onDataTypeListItemUpdate(DataTypeListItem dataTypeListItem) {
        this.view.highlight((Element)dataTypeListItem.getElement());
    }

    private void consumeIfDataTypeIsNotReadOnly(Consumer<DataTypeListItem> dataTypeListItemConsumer) {
        this.getCurrentDataTypeListItem().ifPresent(dataTypeListItem -> {
            if (!dataTypeListItem.isReadOnly()) {
                dataTypeListItemConsumer.accept((DataTypeListItem)dataTypeListItem);
            }
        });
    }

    public static interface View
    extends HasPresenter<DataTypeListShortcuts> {
        public void reset();

        public List<DataTypeListItem> getVisibleDataTypeListItems();

        public Optional<DataTypeListItem> getCurrentDataTypeListItem();

        public Optional<Element> getFirstDataTypeRow();

        public Optional<Element> getNextDataTypeRow();

        public Optional<Element> getPrevDataTypeRow();

        public void highlight(Element var1);

        public void focusIn();
    }
}

