/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

public class DMNGridPanel
extends GridLienzoPanel {
    public static final int LIENZO_PANEL_WIDTH = 1000;
    public static final int LIENZO_PANEL_HEIGHT = 450;
    private DMNGridLayer gridLayer;
    private RestrictedMousePanMediator mousePanMediator;

    public DMNGridPanel(DMNGridLayer gridLayer, RestrictedMousePanMediator mousePanMediator, ContextMenuHandler contextMenuHandler) {
        super(1000, 450);
        this.gridLayer = gridLayer;
        this.mousePanMediator = mousePanMediator;
        this.getDomElementContainer().addDomHandler((EventHandler)this.destroyDOMElements(), MouseWheelEvent.getType());
        this.getDomElementContainer().addDomHandler((EventHandler)contextMenuHandler, ContextMenuEvent.getType());
    }

    private MouseWheelHandler destroyDOMElements() {
        return event -> this.gridLayer.getGridWidgets().forEach(gridWidget -> gridWidget.getModel().getColumns().stream().filter(gridColumn -> gridColumn instanceof HasDOMElementResources).map(gridColumn -> (HasDOMElementResources)gridColumn).forEach(HasDOMElementResources::destroyResources));
    }

    public void onResize() {
        this.doResize(() -> {
            this.updatePanelSize();
            this.refreshScrollPosition();
            TransformMediator restriction = this.mousePanMediator.getTransformMediator();
            Transform transform = restriction.adjust(this.gridLayer.getViewport().getTransform(), this.gridLayer.getVisibleBounds());
            this.gridLayer.getViewport().setTransform(transform);
            this.gridLayer.batch();
        });
    }

    void doResize(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleDeferred(command);
    }
}

