/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.DeleteInputClauseCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DescriptionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteInputClauseCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private DescriptionColumn uiDescriptionColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    private DecisionTable dtable;
    private InputClause inputClause;
    private GridData uiModel;
    private DecisionTableUIModelMapper uiModelMapper;
    private DeleteInputClauseCommand command;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
        this.inputClause = new InputClause();
        this.dtable.getInput().add(this.inputClause);
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        this.makeCommand(1);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
        ((DescriptionColumn)Mockito.doReturn((Object)2).when((Object)this.uiDescriptionColumn)).getIndex();
    }

    private void makeCommand(int uiColumnIndex) {
        this.command = (DeleteInputClauseCommand)Mockito.spy((Object)new DeleteInputClauseCommand(this.dtable, this.uiModel, uiColumnIndex, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandCheck() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecuteRemoveMiddle() {
        InputClause firstInput = (InputClause)Mockito.mock(InputClause.class);
        InputClause lastInput = (InputClause)Mockito.mock(InputClause.class);
        this.dtable.getInput().add(0, firstInput);
        this.dtable.getInput().add(lastInput);
        UnaryTests inputOneValue = (UnaryTests)Mockito.mock(UnaryTests.class);
        UnaryTests inputTwoValue = (UnaryTests)Mockito.mock(UnaryTests.class);
        UnaryTests inputThreeValue = (UnaryTests)Mockito.mock(UnaryTests.class);
        DecisionRule rule = new DecisionRule();
        rule.getInputEntry().add(inputOneValue);
        rule.getInputEntry().add(inputTwoValue);
        rule.getInputEntry().add(inputThreeValue);
        this.dtable.getRule().add(rule);
        this.makeCommand(2);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)2L, (long)this.dtable.getInput().size());
        Assert.assertEquals((Object)firstInput, this.dtable.getInput().get(0));
        Assert.assertEquals((Object)lastInput, this.dtable.getInput().get(1));
        Assert.assertEquals((long)2L, (long)((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().size());
        Assert.assertEquals((Object)inputOneValue, ((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(0));
        Assert.assertEquals((Object)inputThreeValue, ((DecisionRule)this.dtable.getRule().get(0)).getInputEntry().get(1));
    }

    @Test
    public void testGraphCommandExecute() {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
    }

    @Test
    public void testGraphCommandExecuteAndThenUndo() {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)0L, (long)this.dtable.getInput().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getInput().size());
        Assert.assertEquals((Object)this.inputClause, this.dtable.getInput().get(0));
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandExecute() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiDescriptionColumn});
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
        ((DeleteInputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testCanvasCommandExecuteAndThenUndo() throws Exception {
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.execute((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiDescriptionColumn});
        Mockito.reset((Object[])new DeleteInputClauseCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasAddRuleCommand.undo((Object)this.canvasHandler));
        Assertions.assertThat((List)this.uiModel.getColumns()).containsOnly((Object[])new GridColumn[]{this.uiRowNumberColumn, this.uiInputClauseColumn, this.uiDescriptionColumn});
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
        ((DeleteInputClauseCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testComponentWidths() {
        Mockito.when((Object)this.uiInputClauseColumn.getWidth()).thenReturn((Object)100.0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)this.dtable.getRequiredComponentWidthCount(), (long)this.dtable.getComponentWidths().size());
        Assert.assertEquals((double)100.0, (double)((Double)this.dtable.getComponentWidths().get(1)), (double)0.0);
    }
}

