/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.general.BaseNavigateCommand;
import org.kie.workbench.common.dmn.client.commands.general.BaseNavigationCommandTest;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class NavigateToExpressionEditorCommandTest
extends BaseNavigationCommandTest {
    private static final String NODE_UUID = "uuid";

    @Override
    protected BaseNavigateCommand getCommand(boolean isOnlyVisualChangeAllowed) {
        return new NavigateToExpressionEditorCommand(this.editor, (SessionPresenter)this.sessionPresenter, this.sessionManager, this.sessionCommandManager, (Event)this.refreshFormPropertiesEvent, NODE_UUID, this.hasExpression, Optional.of(this.hasName), isOnlyVisualChangeAllowed);
    }

    @Override
    @Test
    public void executeCanvasCommand() {
        this.setup(false);
        this.assertUndoCanvasCommand(false);
    }

    @Test
    public void executeCanvasCommandWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.assertUndoCanvasCommand(true);
    }

    private void assertUndoCanvasCommand(boolean isOnlyVisualChangeAllowed) {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((LienzoCanvas)Mockito.verify((Object)this.canvas)).disableHandlers();
        ((BaseNavigateCommand)Mockito.verify((Object)this.command)).hidePaletteWidget(Mockito.eq((boolean)true));
        ((BaseNavigateCommand)Mockito.verify((Object)this.command)).addExpressionEditorToCanvasWidget();
        ((SessionPresenter.View)Mockito.verify((Object)this.sessionPresenterView)).setCanvasWidget((IsWidget)this.editorContainerForErrai1090);
        ((ExpressionEditorView.Presenter)Mockito.verify((Object)this.editor)).setExpression((String)Mockito.eq((Object)NODE_UUID), (HasExpression)Mockito.eq((Object)this.hasExpression), (Optional)Mockito.eq(Optional.of(this.hasName)), Mockito.eq((boolean)isOnlyVisualChangeAllowed));
        ((ExpressionEditorView)Mockito.verify((Object)this.expressionEditorView)).setFocus();
    }

    @Override
    @Test
    public void undoCanvasCommand() {
        this.setup(false);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((LienzoCanvas)Mockito.verify((Object)this.canvas)).enableHandlers();
        ((BaseNavigateCommand)Mockito.verify((Object)this.command)).hidePaletteWidget(Mockito.eq((boolean)false));
        ((BaseNavigateCommand)Mockito.verify((Object)this.command)).addDRGEditorToCanvasWidget();
        ((SessionPresenter.View)Mockito.verify((Object)this.sessionPresenterView)).setCanvasWidget(this.view);
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).notifyCanvasClear();
    }

    @Test
    public void checkCommandDefinition() {
        this.setup(false);
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
    }
}

