/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.factories;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.decision.factories.DecisionNavigatorBaseItemFactory;
import org.kie.workbench.common.dmn.client.decision.factories.DecisionNavigatorNestedItemFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorBaseItemFactoryTest {
    @Mock
    private DecisionNavigatorNestedItemFactory nestedItemFactory;
    @Mock
    private DecisionNavigatorPresenter decisionNavigatorPresenter;
    @Mock
    private TextPropertyProviderFactory textPropertyProviderFactory;
    @Mock
    private EventSourceMock<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    @Mock
    private EventSourceMock<CanvasSelectionEvent> canvasSelectionEvent;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private TranslationService translationService;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node<View, Edge> node;
    @Mock
    private Element<View> element;
    @Mock
    private DefinitionAdapter<Object> objectDefinitionAdapter;
    private DecisionNavigatorBaseItemFactory factory;

    @Before
    public void setup() {
        this.factory = (DecisionNavigatorBaseItemFactory)Mockito.spy((Object)new DecisionNavigatorBaseItemFactory(this.nestedItemFactory, this.decisionNavigatorPresenter, this.textPropertyProviderFactory, this.canvasFocusedSelectionEvent, this.canvasSelectionEvent, this.definitionUtils, this.translationService));
        Mockito.when((Object)this.decisionNavigatorPresenter.getHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.decisionNavigatorPresenter.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
    }

    @Test
    public void testMakeItem() {
        String itemUUID = "itemUUID";
        String childUUID = "childUUID";
        String graphUUID = "graphUUID";
        String label = "label";
        Command onClick = (Command)Mockito.mock(Command.class);
        Node diagramNode = (Node)Mockito.mock(Node.class);
        Definition diagramDefinition = (Definition)Mockito.mock(Definition.class);
        DMNDiagram diagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        DecisionNavigatorItem child = new DecisionNavigatorItem("childUUID");
        List<DecisionNavigatorItem> nestedItems = Collections.singletonList(child);
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"itemUUID");
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"label").when((Object)this.factory)).getLabel(this.node);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)onClick).when((Object)this.factory)).makeOnClickCommand(this.node);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn(nestedItems).when((Object)this.factory)).makeNestedItems(this.node);
        Mockito.when((Object)this.decisionNavigatorPresenter.getGraph()).thenReturn(Optional.of(this.graph));
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(diagramNode));
        Mockito.when((Object)diagramNode.getContent()).thenReturn((Object)diagramDefinition);
        Mockito.when((Object)diagramDefinition.getDefinition()).thenReturn((Object)diagram);
        Mockito.when((Object)diagramNode.getUUID()).thenReturn((Object)"graphUUID");
        DecisionNavigatorItem item = this.factory.makeItem(this.node, DecisionNavigatorItem.Type.ITEM);
        Assert.assertEquals((Object)"itemUUID", (Object)item.getUUID());
        Assert.assertEquals((Object)"label", (Object)item.getLabel());
        Assert.assertEquals((Object)onClick, (Object)item.getOnClick());
        Assert.assertEquals((Object)"graphUUID", (Object)item.getParentUUID());
        Assert.assertEquals(this.asTreeSet(child), (Object)item.getChildren());
    }

    @Test
    public void testDiagramUUIDWhenGraphIsPresent() {
        String expectedUUID = "graphUUID";
        Node diagramNode = (Node)Mockito.mock(Node.class);
        Definition diagramDefinition = (Definition)Mockito.mock(Definition.class);
        DMNDiagram diagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Mockito.when((Object)this.decisionNavigatorPresenter.getGraph()).thenReturn(Optional.of(this.graph));
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(diagramNode));
        Mockito.when((Object)diagramNode.getContent()).thenReturn((Object)diagramDefinition);
        Mockito.when((Object)diagramDefinition.getDefinition()).thenReturn((Object)diagram);
        Mockito.when((Object)diagramNode.getUUID()).thenReturn((Object)"graphUUID");
        String actualUUID = this.factory.diagramUUID();
        Assert.assertEquals((Object)"graphUUID", (Object)actualUUID);
    }

    @Test
    public void testDiagramUUIDWhenGraphIsNotPresent() {
        Mockito.when((Object)this.decisionNavigatorPresenter.getGraph()).thenReturn(Optional.empty());
        String actualUUID = this.factory.diagramUUID();
        String expectedUUID = "";
        Assert.assertEquals((Object)"", (Object)actualUUID);
    }

    @Test
    public void testMakeOnClickCommand() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Canvas canvas = (Canvas)Mockito.mock(Canvas.class);
        String uuid = "uuid";
        CanvasSelectionEvent canvasSelection = new CanvasSelectionEvent(canvasHandler, "uuid");
        CanvasFocusedShapeEvent canvasFocusedShape = new CanvasFocusedShapeEvent(canvasHandler, "uuid");
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.decisionNavigatorPresenter.getHandler()).thenReturn((Object)canvasHandler);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)canvasSelection).when((Object)this.factory)).makeCanvasSelectionEvent(canvasHandler, "uuid");
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)canvasFocusedShape).when((Object)this.factory)).makeCanvasFocusedShapeEvent(canvasHandler, "uuid");
        ((CanvasHandler)Mockito.doReturn((Object)canvas).when((Object)canvasHandler)).getCanvas();
        this.factory.makeOnClickCommand(this.node).execute();
        ((EventSourceMock)Mockito.verify(this.canvasSelectionEvent)).fire((Object)canvasSelection);
        ((EventSourceMock)Mockito.verify(this.canvasFocusedSelectionEvent)).fire((Object)canvasFocusedShape);
        ((Canvas)Mockito.verify((Object)canvas)).focus();
    }

    @Test
    public void testGetLabelWheNameIsValidAndTitleIsValid() {
        String title = "title";
        String name = "name";
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"name").when((Object)this.factory)).getName(this.element);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"title").when((Object)this.factory)).getTitle(this.element);
        String label = this.factory.getLabel(this.element);
        Assert.assertEquals((Object)label, (Object)"name");
    }

    @Test
    public void testGetLabelWheNameIsBlankAndTitleIsValid() {
        String title = "title";
        String name = "";
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"").when((Object)this.factory)).getName(this.element);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"title").when((Object)this.factory)).getTitle(this.element);
        String label = this.factory.getLabel(this.element);
        Assert.assertEquals((Object)label, (Object)"title");
    }

    @Test
    public void testGetLabelWheNameIsNullAndTitleIsValid() {
        String title = "title";
        Object name = null;
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn(name).when((Object)this.factory)).getName(this.element);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"title").when((Object)this.factory)).getTitle(this.element);
        String label = this.factory.getLabel(this.element);
        Assert.assertEquals((Object)label, (Object)"title");
    }

    @Test
    public void testGetLabelWheTitleIsNull() {
        Object title = null;
        Object name = null;
        String noName = "- No name -";
        Mockito.when((Object)this.translationService.format("DecisionNavigatorBaseItemFactory.NoName", new Object[0])).thenReturn((Object)"- No name -");
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn(name).when((Object)this.factory)).getName(this.element);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn(title).when((Object)this.factory)).getTitle(this.element);
        String label = this.factory.getLabel(this.element);
        Assert.assertEquals((Object)label, (Object)"- No name -");
    }

    @Test
    public void testGetLabelWheTitleIsBlank() {
        String title = "";
        Object name = null;
        String noName = "- No name -";
        Mockito.when((Object)this.translationService.format("DecisionNavigatorBaseItemFactory.NoName", new Object[0])).thenReturn((Object)"- No name -");
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn(name).when((Object)this.factory)).getName(this.element);
        ((DecisionNavigatorBaseItemFactory)Mockito.doReturn((Object)"").when((Object)this.factory)).getTitle(this.element);
        String label = this.factory.getLabel(this.element);
        Assert.assertEquals((Object)label, (Object)"- No name -");
    }

    @Test
    public void testGetName() {
        TextPropertyProvider provider = (TextPropertyProvider)Mockito.mock(TextPropertyProvider.class);
        String expectedName = "text";
        Mockito.when((Object)this.textPropertyProviderFactory.getProvider(this.element)).thenReturn((Object)provider);
        Mockito.when((Object)provider.getText(this.element)).thenReturn((Object)"text");
        String actualName = this.factory.getName(this.element);
        Assert.assertEquals((Object)"text", (Object)actualName);
    }

    @Test
    public void testGetTitle() {
        DefinitionManager definitionManager = (DefinitionManager)Mockito.mock(DefinitionManager.class);
        AdapterManager adapters = (AdapterManager)Mockito.mock(AdapterManager.class);
        View content = (View)Mockito.mock(View.class);
        Object definition = Mockito.mock(Object.class);
        String expectedTitle = "title";
        Mockito.when((Object)this.definitionUtils.getDefinitionManager()).thenReturn((Object)definitionManager);
        Mockito.when((Object)definitionManager.adapters()).thenReturn((Object)adapters);
        Mockito.when((Object)adapters.forDefinition()).thenReturn(this.objectDefinitionAdapter);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn(definition);
        Mockito.when((Object)this.objectDefinitionAdapter.getTitle(definition)).thenReturn((Object)"title");
        String actualTitle = this.factory.getTitle(this.element);
        Assert.assertEquals((Object)"title", (Object)actualTitle);
    }

    @Test
    public void testMakeNestedItemsWhenItemHasNestedItems() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Mockito.when((Object)this.nestedItemFactory.hasNestedElement(this.node)).thenReturn((Object)true);
        Mockito.when((Object)this.nestedItemFactory.makeItem(this.node)).thenReturn((Object)item);
        List nestedItems = this.factory.makeNestedItems(this.node);
        Assert.assertEquals(Collections.singletonList(item), (Object)nestedItems);
    }

    @Test
    public void testMakeNestedItemsWhenItemDoesNotNestedItems() {
        Mockito.when((Object)this.nestedItemFactory.hasNestedElement(this.node)).thenReturn((Object)false);
        List nestedItems = this.factory.makeNestedItems(this.node);
        Assert.assertEquals(Collections.emptyList(), (Object)nestedItems);
    }

    private TreeSet<DecisionNavigatorItem> asTreeSet(final DecisionNavigatorItem child) {
        return new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
    }
}

