/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.included.components;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponentsView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentsViewTest {
    @Mock
    private HTMLSelectElement drgElementFilter;
    @Mock
    private HTMLInputElement termFilter;
    @Mock
    private HTMLDivElement list;
    @Mock
    private HTMLDivElement emptyState;
    @Mock
    private HTMLDivElement loading;
    @Mock
    private TranslationService translationService;
    @Mock
    private DecisionComponents presenter;
    @Mock
    private HTMLDivElement componentsCounter;
    private DecisionComponentsView view;

    @Before
    public void setup() {
        this.view = (DecisionComponentsView)Mockito.spy((Object)new DecisionComponentsView(this.drgElementFilter, this.termFilter, this.list, this.emptyState, this.loading, this.componentsCounter, this.translationService));
        this.view.init(this.presenter);
    }

    @Test
    public void testInit() {
        JQuerySelectPicker selectPicker = (JQuerySelectPicker)Mockito.mock(JQuerySelectPicker.class);
        JQuerySelectPicker.CallbackFunction callback = (JQuerySelectPicker.CallbackFunction)Mockito.mock(JQuerySelectPicker.CallbackFunction.class);
        String placeholder = "placeholder";
        ((DecisionComponentsView)Mockito.doReturn((Object)selectPicker).when((Object)this.view)).getDrgElementFilter();
        Mockito.when((Object)this.view.onDrgElementFilterChange()).thenReturn((Object)callback);
        Mockito.when((Object)this.translationService.format("DecisionComponentsView.EnterText", new Object[0])).thenReturn((Object)"placeholder");
        this.termFilter.placeholder = "something";
        this.view.init();
        ((JQuerySelectPicker)Mockito.verify((Object)selectPicker)).selectpicker("refresh");
        ((JQuerySelectPicker)Mockito.verify((Object)selectPicker)).on("hidden.bs.select", callback);
        Assert.assertEquals((Object)"placeholder", (Object)this.termFilter.placeholder);
    }

    @Test
    public void testOnTermFilterChange() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        String term = "term";
        this.termFilter.value = "term";
        this.view.onTermFilterChange(event);
        ((DecisionComponents)Mockito.verify((Object)this.presenter)).applyTermFilter("term");
    }

    @Test
    public void testClear() {
        Node element = (Node)Mockito.mock(Node.class);
        this.emptyState.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.list.firstChild = element;
        Mockito.when((Object)this.list.removeChild(element)).then(a -> {
            this.list.firstChild = null;
            return element;
        });
        this.view.clear();
        ((DOMTokenList)Mockito.verify((Object)this.emptyState.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testAddListItem() {
        HTMLElement listItemElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        this.view.addListItem(listItemElement);
        ((HTMLDivElement)Mockito.verify((Object)this.list)).appendChild((Node)listItemElement);
    }

    @Test
    public void testShowEmptyState() {
        this.emptyState.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showEmptyState();
        ((DOMTokenList)Mockito.verify((Object)this.emptyState.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowLoading() {
        this.loading.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showLoading();
        ((DOMTokenList)Mockito.verify((Object)this.loading.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideLoading() {
        this.loading.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideLoading();
        ((DOMTokenList)Mockito.verify((Object)this.loading.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testDisableFilterInputs() {
        JQuerySelectPicker selectPicker = (JQuerySelectPicker)Mockito.mock(JQuerySelectPicker.class);
        ((DecisionComponentsView)Mockito.doReturn((Object)selectPicker).when((Object)this.view)).getDrgElementFilter();
        this.termFilter.value = "something";
        this.view.disableFilterInputs();
        Assert.assertEquals((Object)"", (Object)this.termFilter.value);
        Assert.assertTrue((boolean)this.termFilter.disabled);
        Assert.assertTrue((boolean)this.drgElementFilter.disabled);
        ((JQuerySelectPicker)Mockito.verify((Object)selectPicker)).selectpicker("val", "");
        ((JQuerySelectPicker)Mockito.verify((Object)selectPicker)).selectpicker("refresh");
    }

    @Test
    public void testEnableFilterInputs() {
        JQuerySelectPicker selectPicker = (JQuerySelectPicker)Mockito.mock(JQuerySelectPicker.class);
        ((DecisionComponentsView)Mockito.doReturn((Object)selectPicker).when((Object)this.view)).getDrgElementFilter();
        this.view.enableFilterInputs();
        Assert.assertFalse((boolean)this.termFilter.disabled);
        Assert.assertFalse((boolean)this.drgElementFilter.disabled);
        ((JQuerySelectPicker)Mockito.verify((Object)selectPicker)).selectpicker("refresh");
    }

    @Test
    public void testSetComponentsCounter() {
        this.view.setComponentsCounter(Integer.valueOf(123));
        Assert.assertEquals((Object)"123", (Object)this.componentsCounter.textContent);
    }
}

