/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.client.editors.documentation.DocumentationLinkItem;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocumentationLinkItemTest {
    @Mock
    private HTMLDivElement item;
    @Mock
    private HTMLAnchorElement link;
    @Mock
    private HTMLAnchorElement deleteLink;
    private DocumentationLinkItem documentationLinkItem;

    @Before
    public void setup() {
        this.documentationLinkItem = new DocumentationLinkItem(this.item, this.link, this.deleteLink);
    }

    @Test
    public void testInit() {
        String url = "http://www.kiegroup.org";
        String description = "My nice description.";
        DMNExternalLink externalLink = new DMNExternalLink();
        externalLink.setDescription("My nice description.");
        externalLink.setUrl("http://www.kiegroup.org");
        this.documentationLinkItem.init(externalLink);
        Assert.assertEquals((Object)"My nice description.", (Object)this.link.textContent);
        Assert.assertEquals((Object)"http://www.kiegroup.org", (Object)this.link.href);
    }

    @Test
    public void testOnDeleteLinkClick() {
        Consumer onDelete = (Consumer)Mockito.mock(Consumer.class);
        this.documentationLinkItem.setOnDeleted(onDelete);
        DMNExternalLink externalLink = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        this.documentationLinkItem.init(externalLink);
        this.documentationLinkItem.onDeleteLinkClick(null);
        ((Consumer)Mockito.verify((Object)onDelete)).accept(externalLink);
    }
}

