/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=MockitoJUnitRunner.class)
public class ExpressionContainerUIModelMapperTest {
    private static final double MINIMUM_COLUMN_WIDTH = 200.0;
    private static final String NODE_UUID = "uuid";
    @Mock
    private ExpressionEditorColumn uiExpressionColumn;
    @Mock
    private ExpressionContainerGrid expressionContainerGrid;
    @Mock
    private HasName hasName;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid undefinedExpressionEditor;
    @Captor
    private ArgumentCaptor<Optional<String>> nodeUUIDCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private GridCellTuple parent;
    private BaseGridData uiModel;
    private Expression expression;
    private ExpressionGridCache expressionGridCache;
    private ExpressionContainerUIModelMapper mapper;

    public void setup(boolean isOnlyVisualChangeAllowed) {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiExpressionColumn);
        Mockito.when((Object)this.uiExpressionColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiExpressionColumn.getMinimumWidth()).thenReturn((Object)200.0);
        this.parent = new GridCellTuple(0, 0, (GridWidget)this.expressionContainerGrid);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditor.isCacheable()).thenReturn((Object)true);
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        this.expressionGridCache = (ExpressionGridCache)Mockito.spy((Object)new ExpressionGridCacheImpl());
        this.mapper = new ExpressionContainerUIModelMapper(this.parent, () -> this.uiModel, () -> Optional.ofNullable(this.expression), () -> NODE_UUID, () -> this.hasExpression, () -> Optional.of(this.hasName), () -> isOnlyVisualChangeAllowed, this.expressionEditorDefinitionsSupplier, () -> this.expressionGridCache, this.listSelector);
    }

    @Test
    public void testFromDMNModelUndefinedExpressionType() {
        this.setup(false);
        this.expression = null;
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelUndefinedExpressionType(false);
    }

    @Test
    public void testFromDMNModelWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.expression = null;
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelUndefinedExpressionType(true);
    }

    private void assertFromDMNModelUndefinedExpressionType(boolean isOnlyVisualChangeAllowed) {
        this.assertUiModel();
        this.assertEditorType(this.undefinedExpressionEditor.getClass());
        ((UndefinedExpressionEditorDefinition)Mockito.verify((Object)this.undefinedExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.eq((Object)this.parent), (Optional)this.nodeUUIDCaptor.capture(), (HasExpression)Matchers.eq((Object)this.hasExpression), (Optional)Matchers.eq(Optional.of(this.hasName)), Matchers.eq((boolean)isOnlyVisualChangeAllowed), Matchers.eq((int)0));
        Optional nodeUUID = (Optional)this.nodeUUIDCaptor.getValue();
        Assertions.assertThat((boolean)nodeUUID.isPresent()).isTrue();
        Assertions.assertThat((String)((String)nodeUUID.get())).isEqualTo((Object)NODE_UUID);
    }

    @Test
    public void testFromDMNModelLiteralExpressionType() {
        this.setup(false);
        this.expression = new LiteralExpression();
        this.mapper.fromDMNModel(0, 0);
        this.assertUiModel();
        this.assertEditorType(this.literalExpressionEditor.getClass());
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.eq((Object)this.parent), (Optional)this.nodeUUIDCaptor.capture(), (HasExpression)Matchers.eq((Object)this.hasExpression), (Optional)Matchers.eq(Optional.of(this.hasName)), Matchers.eq((boolean)false), Matchers.eq((int)0));
        Optional nodeUUID = (Optional)this.nodeUUIDCaptor.getValue();
        Assertions.assertThat((boolean)nodeUUID.isPresent()).isTrue();
        Assertions.assertThat((String)((String)nodeUUID.get())).isEqualTo((Object)NODE_UUID);
    }

    @Test
    public void testFromDMNModelExpressionGridCacheIsHit() {
        this.setup(false);
        this.expression = new LiteralExpression();
        this.mapper.fromDMNModel(0, 0);
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.eq((Object)this.parent), (Optional)this.nodeUUIDCaptor.capture(), (HasExpression)Matchers.eq((Object)this.hasExpression), (Optional)Matchers.eq(Optional.of(this.hasName)), Matchers.eq((boolean)false), Matchers.eq((int)0));
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache)).putExpressionGrid((String)((Optional)this.nodeUUIDCaptor.getValue()).get(), Optional.of(this.literalExpressionEditor));
        this.mapper.fromDMNModel(0, 0);
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt());
        ((ExpressionGridCache)Mockito.verify((Object)this.expressionGridCache)).putExpressionGrid(Matchers.anyString(), (Optional)Matchers.any(Optional.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testToDMNModelIsUnsupported() {
        this.setup(false);
        this.mapper.toDMNModel(0, 0, () -> null);
    }

    private void assertUiModel() {
        Assertions.assertThat((int)this.uiModel.getRowCount()).isEqualTo(1);
        Assertions.assertThat((int)this.uiModel.getColumnCount()).isEqualTo(1);
    }

    private void assertEditorType(Class<?> clazz) {
        GridCell gridCell = this.uiModel.getCell(0, 0);
        Assertions.assertThat((Object)gridCell).isNotNull();
        Assertions.assertThat((Object)gridCell).isInstanceOf(ContextGridCell.class);
        GridCellValue gridCellValue = gridCell.getValue();
        Assertions.assertThat((Object)gridCellValue).isNotNull();
        Assertions.assertThat((Object)gridCellValue).isInstanceOf(ExpressionCellValue.class);
        ExpressionCellValue ecv = (ExpressionCellValue)gridCellValue;
        Optional editor = (Optional)ecv.getValue();
        Assertions.assertThat((boolean)editor.isPresent()).isTrue();
        Assertions.assertThat(editor.get()).isInstanceOf(clazz);
    }
}

