/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.mocks.MockHasDOMElementResourcesHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.LiteralExpressionPMMLGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorColumnTest {
    private static final double DEFAULT_WIDTH = 100.0;
    private static final int PADDING = 10;
    @Mock
    private GridRenderer renderer;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    private BaseGridData gridData;
    private BaseGrid<Expression> widget;
    private ExpressionEditorColumn column;

    @Before
    public void setUp() {
        this.gridData = new BaseGridData();
        this.widget = new BaseGrid<Expression>(this.gridLayer, (GridData)this.gridData, this.renderer, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.cellEditorControls, this.translationService){};
        this.column = new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, (GridColumn.HeaderMetaData)new BaseHeaderMetaData("column header"), 200.0, this.widget);
    }

    @Test
    public void testMinimalWidthNoContent() {
        this.gridData.appendColumn((GridColumn)this.column);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(100.0);
    }

    @Test
    public void testMinimalWidthOneCellInEachRow() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 150.0);
        this.mockCells(2, 0, 125.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(150.0);
    }

    @Test
    public void testMinimalWidthTwoCellsSum() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 50.0, 60.0);
        this.mockCells(2, 0, 105.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(110.0);
    }

    @Test
    public void testMinimalWidthThreeCellsSum() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 50.0, 60.0);
        this.mockCells(2, 0, 50.0, 60.0, 10.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(120.0);
    }

    @Test
    public void testMinimalWidthDefaultWidth() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 99.0);
        this.mockCells(1, 0, 30.0, 30.0, 30.0);
        this.mockCells(2, 0, 49.0, 50.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(100.0);
    }

    @Test
    public void testMinimalWidthNoCellsInMiddle() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, new double[0]);
        this.mockCells(2, 0, 50.0, 60.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(110.0);
    }

    @Test
    public void testMinimalWidthOneCellInEachRowWithPadding() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCellsWithPadding(0, 0, 10, 100.0);
        this.mockCellsWithPadding(1, 0, 10, 150.0);
        this.mockCellsWithPadding(2, 0, 10, 125.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(170.0);
    }

    @Test
    public void testMinimalWidthTwoCellsSumWithPadding() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCellsWithPadding(0, 0, 10, 100.0);
        this.mockCellsWithPadding(1, 0, 10, 50.0, 60.0);
        this.mockCellsWithPadding(2, 0, 10, 105.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(130.0);
    }

    @Test
    public void testMinimalWidthThreeCellsSumWithPadding() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCellsWithPadding(0, 0, 10, 100.0);
        this.mockCellsWithPadding(1, 0, 10, 50.0, 60.0);
        this.mockCellsWithPadding(2, 0, 10, 50.0, 60.0, 10.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(140.0);
    }

    @Test
    public void testMinimalWidthDefaultWidthWithPadding() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCellsWithPadding(0, 0, 10, 99.0);
        this.mockCellsWithPadding(1, 0, 10, 30.0, 30.0, 30.0);
        this.mockCellsWithPadding(2, 0, 10, 49.0, 50.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(119.0);
    }

    @Test
    public void testMinimalWidthNoCellsInMiddleWithPadding() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCellsWithPadding(0, 0, 10, 100.0);
        this.mockCellsWithPadding(1, 0, 10, new double[0]);
        this.mockCellsWithPadding(2, 0, 10, 50.0, 60.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(130.0);
    }

    @Test
    public void testUpdateInternalWidth() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 110.0);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(200.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(150.0);
    }

    @Test
    public void testUpdateInternalWidthNoCellsInMiddle() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, new double[0]);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(200.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(150.0);
    }

    @Test
    public void testUpdateInternalWidthResizedToSmaller() {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.gridData.appendRow((GridRow)new BaseGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 30.0, 30.0, 30.0);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(80.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(80.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 0)).isEqualTo(30.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 1)).isEqualTo(30.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 2)).isEqualTo(20.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(30.0);
    }

    @Test
    public void testEditNestedUndefinedExpressionGrid() {
        GridCell cell = (GridCell)Mockito.mock(GridCell.class);
        GridCellValue cellValue = (GridCellValue)Mockito.mock(GridCellValue.class);
        UndefinedExpressionGrid undefinedExpressionGrid = (UndefinedExpressionGrid)Mockito.mock(UndefinedExpressionGrid.class);
        Mockito.when((Object)cell.getValue()).thenReturn((Object)cellValue);
        Mockito.when((Object)cellValue.getValue()).thenReturn(Optional.of(undefinedExpressionGrid));
        this.column.edit(cell, null, null);
        ((UndefinedExpressionGrid)Mockito.verify((Object)undefinedExpressionGrid)).startEditingCell(0, 0);
    }

    @Test
    public void testEditNestedNotUndefinedExpressionGrid() {
        GridCell cell = (GridCell)Mockito.mock(GridCell.class);
        GridCellValue cellValue = (GridCellValue)Mockito.mock(GridCellValue.class);
        ContextGrid contextGrid = (ContextGrid)Mockito.mock(ContextGrid.class);
        Mockito.when((Object)cell.getValue()).thenReturn((Object)cellValue);
        Mockito.when((Object)cellValue.getValue()).thenReturn(Optional.of(contextGrid));
        this.column.edit(cell, null, null);
        ((ContextGrid)Mockito.verify((Object)contextGrid)).selectFirstCell();
    }

    @Test
    public void testEditNestedLiteralExpressionGrid() {
        GridCell cell = (GridCell)Mockito.mock(GridCell.class);
        GridCellValue cellValue = (GridCellValue)Mockito.mock(GridCellValue.class);
        LiteralExpressionGrid leGrid = (LiteralExpressionGrid)Mockito.mock(LiteralExpressionGrid.class);
        Mockito.when((Object)cell.getValue()).thenReturn((Object)cellValue);
        Mockito.when((Object)cellValue.getValue()).thenReturn(Optional.of(leGrid));
        this.column.edit(cell, null, null);
        ((LiteralExpressionGrid)Mockito.verify((Object)leGrid)).startEditingCell(0, 0);
    }

    @Test
    public void testEditNestedLiteralExpressionPMMLGrid() {
        GridCell cell = (GridCell)Mockito.mock(GridCell.class);
        GridCellValue cellValue = (GridCellValue)Mockito.mock(GridCellValue.class);
        LiteralExpressionPMMLGrid leGrid = (LiteralExpressionPMMLGrid)Mockito.mock(LiteralExpressionPMMLGrid.class);
        Mockito.when((Object)cell.getValue()).thenReturn((Object)cellValue);
        Mockito.when((Object)cellValue.getValue()).thenReturn(Optional.of(leGrid));
        this.column.edit(cell, null, null);
        ((LiteralExpressionPMMLGrid)Mockito.verify((Object)leGrid)).startEditingCell(0, 0);
    }

    @Test
    public void testHeaderDOMElementsAreDestroyed() {
        MockHasDOMElementResourcesHeaderMetaData mockHeaderMetaData = (MockHasDOMElementResourcesHeaderMetaData)Mockito.mock(MockHasDOMElementResourcesHeaderMetaData.class);
        this.column.getHeaderMetaData().add(mockHeaderMetaData);
        this.column.destroyResources();
        ((MockHasDOMElementResourcesHeaderMetaData)Mockito.verify((Object)mockHeaderMetaData)).destroyResources();
    }

    private void mockCells(int rowIndex, int columnIndex, double ... widthOfCells) {
        this.mockCellsWithPadding(rowIndex, columnIndex, 0, widthOfCells);
    }

    private void mockCellsWithPadding(int rowIndex, int columnIndex, int padding, double ... widthOfCells) {
        this.gridData.setCellValue(rowIndex, columnIndex, (GridCellValue)new ExpressionCellValue(Optional.of(this.mockEditor(padding, widthOfCells))));
    }

    private BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper> mockEditor(final double padding, final double ... widthOfCells) {
        final GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class);
        final GridColumnRenderer gridColumnRenderer = (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class);
        final BaseExpressionGrid gridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)gridWidget.getExpression()).thenReturn(Optional::empty);
        GridCellTuple parent = new GridCellTuple(0, 0, null);
        Optional<Object> hasName = Optional.of(Mockito.mock(HasName.class));
        return new BaseExpressionGrid(parent, Optional.empty(), HasExpression.NOP, hasName, this.gridPanel, this.gridLayer, (GridData)new DMNGridData(), this.renderer, this.definitionUtils, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, this.canvasCommandFactory, (Event)this.editorSelectedEvent, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent, this.cellEditorControls, this.listSelector, this.translationService, false, 0){

            protected BaseUIModelMapper makeUiModelMapper() {
                return null;
            }

            public void initialiseUiColumns() {
                for (final double width : widthOfCells) {
                    this.model.appendColumn((GridColumn)new DMNGridColumn<BaseGrid<Expression>, Object>(headerMetaData, gridColumnRenderer, width, (BaseGrid)gridWidget){
                        {
                            super(x0, x1, x2, x3);
                            this.setMinimumWidth(width);
                            this.setWidth(width);
                        }
                    });
                }
            }

            public void initialiseUiRows() {
            }

            public void initialiseUiCells() {
            }

            public double getPadding() {
                return padding;
            }
        };
    }

    private double getColumnWidth(int rowOfCell, int columnOfCell, int columnInCell) {
        return ((GridColumn)((BaseExpressionGrid)((Optional)((ExpressionCellValue)this.gridData.getCell(rowOfCell, columnOfCell).getValue()).getValue()).get()).getModel().getColumns().get(columnInCell)).getWidth();
    }
}

