/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.BaseDecisionTableEditorDefinitionTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinitionEnricher;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionTableEditorDefinitionEnricherTest
extends BaseDecisionTableEditorDefinitionTest {
    private static final String NODE_UUID = UUID.uuid();
    private static final String INPUT_DATA_NAME_1 = "z-inputData1";
    private static final String INPUT_DATA_NAME_2 = "a-inputData2";
    private static final QName INPUT_DATA_QNAME_1 = BuiltInType.STRING.asQName();
    private static final QName INPUT_DATA_QNAME_2 = BuiltInType.NUMBER.asQName();
    private static final QName OUTPUT_DATA_QNAME = BuiltInType.DATE.asQName();
    private DMNDiagram diagram;
    private InputData inputData1;
    private InputData inputData2;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.diagram = new DMNDiagram();
        this.inputData1 = new InputData();
        this.inputData2 = new InputData();
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputData() {
        this.setupGraph();
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_1);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 2, 1);
        this.assertParentHierarchyEnrichment(model, 2, 1);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndSimpleCustomType() {
        this.setupGraph();
        Definitions definitions = this.diagram.getDefinitions();
        String simpleItemDefinitionName = "tSmurf";
        QName simpleItemDefinitionTypeRef = new QName("", BuiltInType.DATE.getName());
        ItemDefinition simpleItemDefinition = new ItemDefinition();
        simpleItemDefinition.setName(new Name("tSmurf"));
        simpleItemDefinition.setTypeRef(simpleItemDefinitionTypeRef);
        definitions.getItemDefinition().add(simpleItemDefinition);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)simpleItemDefinitionTypeRef);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 2, 1);
        this.assertParentHierarchyEnrichment(model, 2, 1);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndComplexCustomType() {
        this.setupGraph();
        Definitions definitions = this.diagram.getDefinitions();
        String complexItemDefinitionName = "tSmurf";
        String complexItemDefinitionPart1Name = "tDateOfBirth";
        String complexItemDefinitionPart2Name = "tIsBlue";
        final QName complexItemDefinitionPart1TypeRef = new QName("", BuiltInType.DATE.getName());
        final QName complexItemDefinitionPart2TypeRef = new QName("", BuiltInType.BOOLEAN.getName());
        ItemDefinition complexItemDefinition = new ItemDefinition();
        complexItemDefinition.setName(new Name("tSmurf"));
        complexItemDefinition.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tDateOfBirth"));
                this.setTypeRef(complexItemDefinitionPart1TypeRef);
            }
        });
        complexItemDefinition.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tIsBlue"));
                this.setTypeRef(complexItemDefinitionPart2TypeRef);
            }
        });
        definitions.getItemDefinition().add(complexItemDefinition);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(3);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.tDateOfBirth");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)complexItemDefinitionPart1TypeRef);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.tIsBlue");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)complexItemDefinitionPart2TypeRef);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 3, 1);
        this.assertParentHierarchyEnrichment(model, 3, 1);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndRecursiveCustomType() {
        this.setupGraph();
        Definitions definitions = this.diagram.getDefinitions();
        String tSmurfName = "tSmurf";
        String tDateOfBirthName = "tDateOfBirth";
        String tIsBlueName = "tIsBlue";
        String tParentName = "tParent";
        final QName dateBuiltInType = new QName("", BuiltInType.DATE.getName());
        final QName booleanBuiltInType = new QName("", BuiltInType.BOOLEAN.getName());
        final QName parentCustomType = new QName("", "tSmurf");
        ItemDefinition tSmurfCustomDataType = new ItemDefinition();
        tSmurfCustomDataType.setName(new Name("tSmurf"));
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tDateOfBirth"));
                this.setTypeRef(dateBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tIsBlue"));
                this.setTypeRef(booleanBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tParent"));
                this.setTypeRef(parentCustomType);
            }
        });
        definitions.getItemDefinition().add(tSmurfCustomDataType);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(4);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.tDateOfBirth");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)dateBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.tIsBlue");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)booleanBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(3)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.tParent");
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression().getTypeRef()).isEqualTo((Object)parentCustomType);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 4, 1);
        this.assertParentHierarchyEnrichment(model, 4, 1);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithMultipleHierarchyCustomTypes() {
        this.setupGraph();
        Definitions definitions = this.diagram.getDefinitions();
        String tSmurf = "tSmurf";
        String tSmurfAddress = "tSmurfAddress";
        final QName dateBuiltInType = new QName("", BuiltInType.DATE.getName());
        final QName stringBuiltInType = new QName("", BuiltInType.STRING.getName());
        final ItemDefinition tSmurfAddressCustomDataType = new ItemDefinition();
        tSmurfAddressCustomDataType.setName(new Name("tSmurfAddress"));
        tSmurfAddressCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("line1"));
                this.setTypeRef(stringBuiltInType);
            }
        });
        tSmurfAddressCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("line2"));
                this.setTypeRef(stringBuiltInType);
            }
        });
        ItemDefinition tSmurfCustomDataType = new ItemDefinition();
        tSmurfCustomDataType.setName(new Name("tSmurf"));
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("dob"));
                this.setTypeRef(dateBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("address"));
                this.getItemComponent().add(tSmurfAddressCustomDataType);
            }
        });
        definitions.getItemDefinition().add(tSmurfCustomDataType);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(4);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.address.tSmurfAddress.line1");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)stringBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.address.tSmurfAddress.line2");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)stringBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(3)).getInputExpression().getText().getValue()).isEqualTo((Object)"z-inputData1.dob");
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression().getTypeRef()).isEqualTo((Object)dateBuiltInType);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 4, 1);
        this.assertParentHierarchyEnrichment(model, 4, 1);
    }

    private void setupGraph() {
        NodeImpl diagramNode = new NodeImpl(UUID.uuid());
        NodeImpl sourceNode1 = new NodeImpl(UUID.uuid());
        NodeImpl sourceNode2 = new NodeImpl(UUID.uuid());
        NodeImpl targetNode = new NodeImpl(NODE_UUID);
        this.inputData1.getName().setValue(INPUT_DATA_NAME_1);
        this.inputData2.getName().setValue(INPUT_DATA_NAME_2);
        QName inputData1QName = new QName("", BuiltInType.STRING.getName());
        QName inputData2QName = new QName("", BuiltInType.NUMBER.getName());
        this.inputData1.getVariable().setTypeRef(inputData1QName);
        this.inputData2.getVariable().setTypeRef(inputData2QName);
        DefinitionImpl sourceNode1Definition = new DefinitionImpl((Object)this.inputData1);
        DefinitionImpl sourceNode2Definition = new DefinitionImpl((Object)this.inputData2);
        sourceNode1.setContent((Object)sourceNode1Definition);
        sourceNode2.setContent((Object)sourceNode2Definition);
        EdgeImpl edge1 = new EdgeImpl(UUID.uuid());
        EdgeImpl edge2 = new EdgeImpl(UUID.uuid());
        edge1.setTargetNode((Node)targetNode);
        edge1.setSourceNode((Node)sourceNode1);
        edge2.setTargetNode((Node)targetNode);
        edge2.setSourceNode((Node)sourceNode2);
        targetNode.getInEdges().add(edge1);
        targetNode.getInEdges().add(edge2);
        sourceNode1.getOutEdges().add(edge1);
        sourceNode2.getOutEdges().add(edge2);
        DefinitionImpl diagramDefinition = new DefinitionImpl((Object)this.diagram);
        diagramNode.setContent((Object)diagramDefinition);
        this.graph.addNode((Node)diagramNode);
        this.graph.addNode((Node)targetNode);
        this.graph.addNode((Node)sourceNode1);
        this.graph.addNode((Node)sourceNode2);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithoutInputData() {
        String uuid = UUID.uuid();
        NodeImpl node = new NodeImpl(uuid);
        this.graph.addNode((Node)node);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(uuid), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testModelEnrichmentWhenParentIsContextEntry() {
        String name = "context-entry";
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        context.getContextEntry().add(contextEntry);
        contextEntry.setVariable(new InformationItem(new Id(), new Description(), new Name("context-entry"), OUTPUT_DATA_QNAME));
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)contextEntry);
        contextEntry.setParent((DMNModelInstrumentedBase)context);
        context.setParent((DMNModelInstrumentedBase)this.decision);
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"context-entry");
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testModelEnrichmentWhenParentIsContextEntryDefaultResult() {
        String name = "decision";
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        context.getContextEntry().add(contextEntry);
        contextEntry.setParent((DMNModelInstrumentedBase)context);
        context.setParent((DMNModelInstrumentedBase)this.decision);
        this.decision.setName(new Name("decision"));
        this.decision.getVariable().setTypeRef(OUTPUT_DATA_QNAME);
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)contextEntry);
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"decision");
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testModelEnrichmentWhenParentIsNestedContextEntryDefaultResult() {
        String name = "context-entry";
        Context innerContext = new Context();
        ContextEntry innerContextEntry = new ContextEntry();
        innerContext.getContextEntry().add(innerContextEntry);
        innerContextEntry.setParent((DMNModelInstrumentedBase)innerContext);
        Context outerContext = new Context();
        ContextEntry outerContextEntry = new ContextEntry();
        outerContext.getContextEntry().add(outerContextEntry);
        outerContextEntry.setParent((DMNModelInstrumentedBase)outerContext);
        innerContext.setParent((DMNModelInstrumentedBase)outerContextEntry);
        outerContext.setParent((DMNModelInstrumentedBase)this.decision);
        outerContextEntry.setVariable(new InformationItem(new Id(), new Description(), new Name("context-entry"), OUTPUT_DATA_QNAME));
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)innerContextEntry);
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"context-entry");
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testModelEnrichmentWhenHasExpressionIsHasVariable() {
        this.decision.setVariable(new InformationItemPrimary(new Id(), new Name(), OUTPUT_DATA_QNAME));
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"output-1");
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testModelEnrichmentWhenHasExpressionIsNotHasVariable() {
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"output-1");
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)BuiltInType.UNDEFINED.asQName());
        this.assertStandardDecisionRuleEnrichment(model, 1, 1);
        this.assertParentHierarchyEnrichment(model, 1, 1);
    }

    @Test
    public void testAddInputClauseRequirement() {
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition name = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition age = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ArrayList inputClauseRequirements = new ArrayList();
        String inputData = "InputData";
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, null, this.itemDefinitionUtils);
        Mockito.when((Object)name.getName()).thenReturn((Object)new Name("name"));
        Mockito.when((Object)name.getTypeRef()).thenReturn((Object)BuiltInType.STRING.asQName());
        Mockito.when((Object)name.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)age.getName()).thenReturn((Object)new Name("age"));
        Mockito.when((Object)age.getTypeRef()).thenReturn((Object)BuiltInType.NUMBER.asQName());
        Mockito.when((Object)age.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)tPerson.getName()).thenReturn((Object)new Name("tPerson"));
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn(null);
        Mockito.when((Object)tPerson.getItemComponent()).thenReturn(Arrays.asList(name, age));
        enricher.addInputClauseRequirement(tPerson, inputClauseRequirements, "InputData");
        Assert.assertEquals((long)2L, (long)inputClauseRequirements.size());
        DecisionTableEditorDefinitionEnricher.InputClauseRequirement inputClause1 = (DecisionTableEditorDefinitionEnricher.InputClauseRequirement)inputClauseRequirements.get(0);
        DecisionTableEditorDefinitionEnricher.InputClauseRequirement inputClause2 = (DecisionTableEditorDefinitionEnricher.InputClauseRequirement)inputClauseRequirements.get(1);
        Assert.assertEquals((Object)"InputData.name", (Object)inputClause1.text);
        Assert.assertEquals((Object)BuiltInType.STRING.getName(), (Object)inputClause1.typeRef.getLocalPart());
        Assert.assertEquals((Object)"InputData.age", (Object)inputClause2.text);
        Assert.assertEquals((Object)BuiltInType.NUMBER.getName(), (Object)inputClause2.typeRef.getLocalPart());
    }

    @Test
    public void testAddInputClauseRequirementWhenDataTypeIsStructureAndDontHaveFields() {
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String inputData = "InputData";
        ArrayList inputClauseRequirements = new ArrayList();
        ItemDefinitionUtils itemDefinitionUtils = new ItemDefinitionUtils((DMNGraphUtils)Mockito.mock(DMNGraphUtils.class));
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, null, itemDefinitionUtils);
        Mockito.when((Object)tPerson.getName()).thenReturn((Object)new Name("tPerson"));
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn(null);
        Mockito.when((Object)tPerson.getItemComponent()).thenReturn(Collections.emptyList());
        enricher.addInputClauseRequirement(tPerson, inputClauseRequirements, "InputData");
        Assert.assertEquals((long)1L, (long)inputClauseRequirements.size());
        Assert.assertEquals((Object)"InputData", (Object)((DecisionTableEditorDefinitionEnricher.InputClauseRequirement)inputClauseRequirements.get((int)0)).text);
        Assert.assertEquals((Object)"tPerson", (Object)((DecisionTableEditorDefinitionEnricher.InputClauseRequirement)inputClauseRequirements.get((int)0)).typeRef.getLocalPart());
    }
}

