/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.client.core.shape.ContainerNode;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.AddParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.RemoveParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetKindCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.UpdateParameterNameCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.UpdateParameterTypeRefCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnNameHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector.KindPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class FunctionGridTest {
    private static final String PARAMETER_NAME = "name";
    private static final String NODE_UUID = "uuid";
    private static final String NAME = "name";
    private static final String NAME_NEW = "name-new";
    private static final int CLEAR_EXPRESSION_TYPE = 0;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private Index index;
    @Mock
    private Element element;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    @Mock
    private ParametersPopoverView.Presenter parametersEditor;
    @Mock
    private KindPopoverView.Presenter kindEditor;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private GridCellTuple parent;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    @Mock
    private ExpressionEditorDefinition supplementaryExpressionEditorDefinition;
    @Mock
    private FunctionSupplementaryGrid supplementaryExpressionEditor;
    @Mock
    private Command onSuccess;
    @Mock
    private NameAndDataTypePopoverView.Presenter headerEditor;
    @Captor
    private ArgumentCaptor<AddParameterCommand> addParameterCommandCaptor;
    @Captor
    private ArgumentCaptor<RemoveParameterCommand> removeParameterCommandCaptor;
    @Captor
    private ArgumentCaptor<UpdateParameterNameCommand> updateParameterNameCommandCaptor;
    @Captor
    private ArgumentCaptor<UpdateParameterTypeRefCommand> updateParameterTypeRefCommandCaptor;
    @Captor
    private ArgumentCaptor<SetKindCommand> setKindCommandCaptor;
    @Captor
    private ArgumentCaptor<ClearExpressionTypeCommand> clearExpressionTypeCommandCaptor;
    @Captor
    private ArgumentCaptor<Optional<ExpressionEditorDefinition<Expression>>> expressionDefinitionCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<GridCellTuple> parentCaptor;
    @Captor
    private ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    private LiteralExpressionEditorDefinition literalExpressionEditorDefinition;
    private Context supplementaryExpression = new Context();
    private Decision hasExpression = new Decision();
    private Optional<FunctionDefinition> expression = Optional.empty();
    private Optional<HasName> hasName = Optional.empty();
    private InformationItem parameter = new InformationItem();
    private FunctionEditorDefinition definition;
    private FunctionGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = new FunctionEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.headerEditor, this.parametersEditor, this.kindEditor);
        this.literalExpressionEditorDefinition = (LiteralExpressionEditorDefinition)Mockito.spy((Object)new LiteralExpressionEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.headerEditor));
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.hasExpression, this.expression);
        this.expression.get().getFormalParameter().add(this.parameter);
        this.parameter.getName().setValue("name");
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.supplementaryExpressionEditorDefinition);
        Decision decision = new Decision();
        decision.setName(new Name("name"));
        this.hasName = Optional.of(decision);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.supplementaryEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        ((LiteralExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt());
        Mockito.when((Object)this.literalExpressionEditor.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.literalExpressionEditor.getLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.literalExpressionEditor.getModel()).thenReturn((Object)new BaseGridData(false));
        ((LiteralExpressionGrid)Mockito.doCallRealMethod().when((Object)this.literalExpressionEditor)).resize((Function)Matchers.any(Function.class));
        ((LiteralExpressionGrid)Mockito.doCallRealMethod().when((Object)this.literalExpressionEditor)).doResize((GridLayerRedrawManager.PrioritizedCommand)Matchers.any(GridLayerRedrawManager.PrioritizedCommand.class), (Function)Matchers.any(Function.class));
        ((LiteralExpressionGrid)Mockito.doCallRealMethod().when((Object)this.literalExpressionEditor)).selectFirstCell();
        Mockito.when((Object)this.literalExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.supplementaryExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.supplementaryExpression));
        Mockito.when((Object)this.supplementaryExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.supplementaryExpressionEditor));
        Mockito.when((Object)this.supplementaryExpressionEditor.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.supplementaryExpressionEditor.getLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.supplementaryExpressionEditor.getModel()).thenReturn((Object)new BaseGridData(false));
        ((FunctionSupplementaryGrid)Mockito.doCallRealMethod().when((Object)this.supplementaryExpressionEditor)).resize((Function)Matchers.any(Function.class));
        ((FunctionSupplementaryGrid)Mockito.doCallRealMethod().when((Object)this.supplementaryExpressionEditor)).doResize((GridLayerRedrawManager.PrioritizedCommand)Matchers.any(GridLayerRedrawManager.PrioritizedCommand.class), (Function)Matchers.any(Function.class));
        ((FunctionSupplementaryGrid)Mockito.doCallRealMethod().when((Object)this.supplementaryExpressionEditor)).selectFirstCell();
        Mockito.when((Object)this.supplementaryExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.index.get(Matchers.anyString())).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getContent()).thenReturn(Mockito.mock(Definition.class));
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(Matchers.any())).thenReturn((Object)"name");
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)Matchers.any(Element.class), Matchers.anyString(), Matchers.any())).thenReturn(Mockito.mock(UpdateElementPropertyCommand.class));
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    private void setupGrid(int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (FunctionGrid)Mockito.spy((Object)((FunctionGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty(), (HasExpression)this.hasExpression, this.hasName, false, nesting).get()));
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)0);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof DMNGridData));
        Assert.assertEquals((long)2L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertTrue((boolean)(uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)uiModel.getCell(0, 1).getValue();
        Assert.assertTrue((boolean)(((Optional)dcv.getValue()).get() instanceof LiteralExpressionGrid));
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(0);
        this.assertComponentWidths(50.0, 150.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 100.0);
        componentWidths.set(1, 200.0);
        this.setupGrid(0);
        this.assertComponentWidths(100.0, 200.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testColumnMetaData() {
        this.setupGrid(0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof FunctionColumnNameHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof FunctionColumnParametersHeaderMetaData));
        FunctionColumnNameHeaderMetaData md1 = (FunctionColumnNameHeaderMetaData)header.get(0);
        FunctionColumnParametersHeaderMetaData md2 = (FunctionColumnParametersHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)"name", (Object)md1.getTitle());
        Assert.assertEquals((Object)"F", (Object)md2.getExpressionLanguageTitle());
        Assert.assertEquals((Object)"(name)", (Object)md2.getFormalParametersTitle());
    }

    @Test
    public void testColumnMetaDataWhenNested() {
        this.setupGrid(1);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof FunctionColumnParametersHeaderMetaData));
        FunctionColumnParametersHeaderMetaData md1 = (FunctionColumnParametersHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)"F", (Object)md1.getExpressionLanguageTitle());
        Assert.assertEquals((Object)"(name)", (Object)md1.getFormalParametersTitle());
    }

    @Test
    public void testOnItemSelectedExpressionColumnDefinedExpressionType() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 1);
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        this.assertListSelectorItem((HasListSelectorControl.ListSelectorItem)items.get(0), "ExpressionEditor.Clear");
        ((HasListSelectorControl.ListSelectorTextItem)items.get(0)).getCommand().execute();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(ClearExpressionTypeCommand.class));
    }

    @Test
    public void testOnItemSelectedExpressionColumnUndefinedExpressionType() {
        this.setupGrid(0);
        this.grid.getModel().setCellValue(0, 0, (GridCellValue)new ExpressionCellValue(Optional.empty()));
        this.assertNoListItems(this.grid.getItems(0, 0));
    }

    private void assertNoListItems(List<HasListSelectorControl.ListSelectorItem> items) {
        Assertions.assertThat((int)items.size()).isEqualTo(0);
    }

    private void assertListSelectorItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo((Object)text);
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testGetParameters() {
        this.setupGrid(0);
        List parameters = this.grid.getParameters();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((Object)this.parameter, parameters.get(0));
        Assert.assertEquals((Object)"name", (Object)((InformationItem)parameters.get(0)).getName().getValue());
    }

    @Test
    public void testAddParameter() {
        this.setupGrid(0);
        this.grid.addParameter(this.onSuccess);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.addParameterCommandCaptor.capture());
        AddParameterCommand addParameterCommand = (AddParameterCommand)this.addParameterCommandCaptor.getValue();
        addParameterCommand.execute(this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((Command)Mockito.verify((Object)this.onSuccess)).execute();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
    }

    @Test
    public void testRemoveParameter() {
        this.setupGrid(0);
        this.grid.removeParameter(this.parameter, this.onSuccess);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.removeParameterCommandCaptor.capture());
        RemoveParameterCommand removeParameterCommand = (RemoveParameterCommand)this.removeParameterCommandCaptor.getValue();
        removeParameterCommand.execute(this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((Command)Mockito.verify((Object)this.onSuccess)).execute();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).setFocus(true);
    }

    @Test
    public void testUpdateParameterName() {
        this.setupGrid(0);
        this.grid.updateParameterName(this.parameter, "name");
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.updateParameterNameCommandCaptor.capture());
        UpdateParameterNameCommand updateParameterNameCommand = (UpdateParameterNameCommand)this.updateParameterNameCommandCaptor.getValue();
        updateParameterNameCommand.execute(this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testUpdateParameterTypeRef() {
        this.setupGrid(0);
        this.grid.updateParameterTypeRef(this.parameter, new QName("", BuiltInType.DATE.getName()));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.updateParameterTypeRefCommandCaptor.capture());
        UpdateParameterTypeRefCommand updateParameterTypeRefCommand = (UpdateParameterTypeRefCommand)this.updateParameterTypeRefCommandCaptor.getValue();
        updateParameterTypeRefCommand.execute(this.canvasHandler);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetKindFEEL() {
        this.setupGrid(0);
        this.grid.setKind(FunctionDefinition.Kind.FEEL);
        this.assertSetKind((ExpressionEditorDefinition)this.literalExpressionEditorDefinition, (BaseExpressionGrid)this.literalExpressionEditor, FunctionDefinition.Kind.FEEL, LiteralExpression.class, LiteralExpressionGrid.class);
        ((LiteralExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq((Object)this.expression.get()), (Optional)Matchers.eq(this.hasName), Matchers.eq((boolean)false), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((Object)this.grid, (Object)parent.getGridWidget());
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)1L, (long)parent.getColumnIndex());
    }

    @Test
    public void testSetKindJava() {
        this.setupGrid(0);
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.FUNCTION_JAVA).when((Object)this.supplementaryExpressionEditorDefinition)).getType();
        this.grid.setKind(FunctionDefinition.Kind.JAVA);
        this.assertSetKind(this.supplementaryExpressionEditorDefinition, (BaseExpressionGrid)this.supplementaryExpressionEditor, FunctionDefinition.Kind.JAVA, Context.class, FunctionSupplementaryGrid.class);
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.supplementaryExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq((Object)this.expression.get()), (Optional)Matchers.eq(this.hasName), Matchers.eq((boolean)false), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((Object)this.grid, (Object)parent.getGridWidget());
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)1L, (long)parent.getColumnIndex());
    }

    @Test
    public void testSetKindPMML() {
        this.setupGrid(0);
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.FUNCTION_PMML).when((Object)this.supplementaryExpressionEditorDefinition)).getType();
        this.grid.setKind(FunctionDefinition.Kind.PMML);
        this.assertSetKind(this.supplementaryExpressionEditorDefinition, (BaseExpressionGrid)this.supplementaryExpressionEditor, FunctionDefinition.Kind.PMML, Context.class, FunctionSupplementaryGrid.class);
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.supplementaryExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq((Object)this.expression.get()), (Optional)Matchers.eq(this.hasName), Matchers.eq((boolean)false), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((Object)this.grid, (Object)parent.getGridWidget());
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)1L, (long)parent.getColumnIndex());
    }

    private void assertSetKind(ExpressionEditorDefinition definition, BaseExpressionGrid editor, FunctionDefinition.Kind expectedKind, Class<?> expectedExpressionType, Class<?> expectedEditorType) {
        ((FunctionGrid)Mockito.verify((Object)this.grid)).doSetKind((FunctionDefinition.Kind)Matchers.eq((Object)expectedKind), (FunctionDefinition)Matchers.eq((Object)this.expression.get()), (Optional)this.expressionDefinitionCaptor.capture());
        ((ExpressionEditorDefinition)Mockito.verify((Object)definition)).enrich((Optional)Matchers.any(Optional.class), (HasExpression)Matchers.eq((Object)this.hasExpression), (Optional)Matchers.any(Optional.class));
        ExpressionEditorDefinition expressionDefinition = (ExpressionEditorDefinition)((Optional)this.expressionDefinitionCaptor.getValue()).get();
        Assertions.assertThat(expectedExpressionType).isAssignableFrom(new Class[]{((Expression)expressionDefinition.getModelClass().get()).getClass()});
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.setKindCommandCaptor.capture());
        SetKindCommand setKindCommand = (SetKindCommand)this.setKindCommandCaptor.getValue();
        setKindCommand.execute(this.canvasHandler);
        GridCellValue gcv = this.grid.getModel().getCell(0, 1).getValue();
        Assert.assertTrue((boolean)(gcv instanceof ExpressionCellValue));
        ExpressionCellValue ecv = (ExpressionCellValue)gcv;
        Assertions.assertThat(expectedEditorType).isAssignableFrom(new Class[]{((BaseExpressionGrid)((Optional)ecv.getValue()).get()).getClass()});
        ((BaseExpressionGrid)Mockito.verify((Object)editor)).resize((Function)Matchers.eq((Object)BaseExpressionGrid.RESIZE_EXISTING));
        ((BaseExpressionGrid)Mockito.verify((Object)editor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        Mockito.reset((Object[])new ContainerNode[]{this.grid, this.gridLayer});
        setKindCommand.undo(this.canvasHandler);
        ((FunctionGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((FunctionGrid)Mockito.verify((Object)this.grid)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testClearExpressionType() {
        ((LiteralExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt());
        this.setupGrid(0);
        this.grid.clearExpressionType();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.clearExpressionTypeCommandCaptor.capture());
        ClearExpressionTypeCommand clearExpressionTypeCommand = (ClearExpressionTypeCommand)this.clearExpressionTypeCommandCaptor.getValue();
        clearExpressionTypeCommand.execute(this.canvasHandler);
        ((FunctionGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.literalExpressionEditor);
        ((LiteralExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        Mockito.reset((Object[])new ContainerNode[]{this.grid, this.gridLayer});
        clearExpressionTypeCommand.undo(this.canvasHandler);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(1)).getWidth()).isEqualTo(150.0);
        ((FunctionGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((FunctionGrid)Mockito.verify((Object)this.grid)).selectExpressionEditorFirstCell(Matchers.eq((int)0), Matchers.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.literalExpressionEditor);
        ((LiteralExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor, (VerificationMode)Mockito.times((int)2))).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testResizeWhenExpressionEditorChanged() {
        this.setupGrid(0);
        double literalWidth = 200.0;
        double changeKindColumnWidth = 150.0;
        double columnWidth = 350.0 + 2.0 * this.grid.getPadding();
        ((GridColumn)this.grid.getModel().getColumns().get(0)).setWidth(200.0);
        this.grid.resize(BaseExpressionGrid.RESIZE_EXISTING);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(Matchers.eq((double)columnWidth), (Function)Matchers.eq((Object)BaseExpressionGrid.RESIZE_EXISTING));
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        command.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testGetDisplayName() {
        this.setupGrid(0);
        Assertions.assertThat((String)this.extractHeaderMetaData().getName().getValue()).isEqualTo((Object)"name");
    }

    private FunctionColumnNameHeaderMetaData extractHeaderMetaData() {
        FunctionColumn column = (FunctionColumn)this.grid.getModel().getColumns().get(1);
        return (FunctionColumnNameHeaderMetaData)column.getHeaderMetaData().get(0);
    }

    @Test
    public void testSetDisplayNameWithNoChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name("name"));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(org.kie.workbench.common.stunner.core.command.Command.class));
    }

    @Test
    public void testSetDisplayNameWithEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNullValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(null);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNonEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name(NAME_NEW));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), SetHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testGetTypeRef() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().getTypeRef()).isNotNull();
    }

    @Test
    public void testSetTypeRef() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName("", BuiltInType.DATE.getName()));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSelectFirstCell() {
        ((LiteralExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt());
        this.setupGrid(0);
        this.grid.selectFirstCell();
        ((FunctionGrid)Mockito.verify((Object)this.grid)).selectCell(Matchers.eq((int)0), Matchers.eq((int)0), Matchers.eq((boolean)false), Matchers.eq((boolean)false));
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderNameRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 0, false, false);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.hasExpression);
    }

    @Test
    public void testSelectHeaderParametersRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(1, 1, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderParametersRowWhenNested() {
        this.setupGrid(1);
        this.grid.selectHeaderCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    private void assertNOPDomainObjectSelection() {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().asDMNModelInstrumentedBase()).isInstanceOf(this.hasExpression.getVariable().getClass());
    }
}

