/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=MockitoJUnitRunner.class)
public class FunctionUIModelMapperTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    @Mock
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition supplementaryEditorDefinition;
    @Mock
    private FunctionSupplementaryGrid supplementaryEditor;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Captor
    private ArgumentCaptor<GridCellTuple> parentCaptor;
    private Context context = new Context();
    private BaseGridData uiModel;
    private FunctionDefinition function;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private FunctionUIModelMapper mapper;

    public void setup(boolean isOnlyVisualChangeAllowedSupplier) {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        ExpressionEditorDefinitions supplementaryEditorDefinitions = new ExpressionEditorDefinitions();
        supplementaryEditorDefinitions.add((Object)this.supplementaryEditorDefinition);
        Mockito.when((Object)this.supplementaryEditorDefinitionsSupplier.get()).thenReturn((Object)supplementaryEditorDefinitions);
        Mockito.when((Object)this.supplementaryEditorDefinition.getModelClass()).thenReturn(Optional.of(this.context));
        Mockito.when((Object)this.supplementaryEditor.getExpression()).thenReturn(() -> Optional.of(this.context));
        Mockito.when((Object)this.supplementaryEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.supplementaryEditor));
        this.function = new FunctionDefinition();
        this.mapper = new FunctionUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.function), () -> isOnlyVisualChangeAllowedSupplier, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.listSelector, 1);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelExpressionKindFEEL() {
        this.setup(false);
        this.function.setExpression((Expression)this.literalExpression);
        this.function.setKind(FunctionDefinition.Kind.FEEL);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.literalExpressionEditor, this.literalExpressionEditorDefinition, false);
    }

    @Test
    public void testFromDMNModelExpressionKindJava() {
        this.setup(false);
        this.function.setExpression((Expression)this.context);
        this.function.setKind(FunctionDefinition.Kind.JAVA);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor, this.supplementaryEditorDefinition, false);
    }

    @Test
    public void testFromDMNModelExpressionKindPMML() {
        this.setup(false);
        this.function.setExpression((Expression)this.context);
        this.function.setKind(FunctionDefinition.Kind.PMML);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor, this.supplementaryEditorDefinition, false);
    }

    @Test
    public void testFromDMNModelExpressionKindFEELWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.function.setExpression((Expression)this.literalExpression);
        this.function.setKind(FunctionDefinition.Kind.FEEL);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.literalExpressionEditor, this.literalExpressionEditorDefinition, true);
    }

    @Test
    public void testFromDMNModelExpressionKindJavaWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.function.setExpression((Expression)this.context);
        this.function.setKind(FunctionDefinition.Kind.JAVA);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor, this.supplementaryEditorDefinition, true);
    }

    @Test
    public void testFromDMNModelExpressionKindPMMLWhenOnlyVisualChangeAllowed() {
        this.setup(true);
        this.function.setExpression((Expression)this.context);
        this.function.setKind(FunctionDefinition.Kind.PMML);
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor, this.supplementaryEditorDefinition, true);
    }

    private void assertFromDMNModelEditor(BaseExpressionGrid editor, ExpressionEditorDefinition definition, boolean isOnlyVisualChangeAllowedSupplier) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 0).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 0).getValue();
        Assert.assertEquals((Object)editor, ((Optional)dcv.getValue()).get());
        ((ExpressionEditorDefinition)Mockito.verify((Object)definition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq((Object)this.function), (Optional)Matchers.eq(Optional.empty()), Matchers.eq((boolean)isOnlyVisualChangeAllowedSupplier), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)0L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testToDMNModelExpressionKindFEEL() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)this.function.getExpression());
    }

    @Test
    public void testToDMNModelExpressionKindJavaAndPMML() {
        this.setup(false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.supplementaryEditor)));
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        Assert.assertEquals((Object)this.context, (Object)this.function.getExpression());
    }
}

