/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLParameterMetadata;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.PMMLDocumentMetadataProvider;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PMMLDocumentMetadataProviderTest {
    @Mock
    private DMNGraphUtils graphUtils;
    @Mock
    private DMNClientServicesProxy clientServicesProxy;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private Path dmnModelPath;
    @Captor
    private ArgumentCaptor<List<PMMLIncludedModel>> pmmlIncludedModelsArgumentCaptor;
    @Captor
    private ArgumentCaptor<ServiceCallback<List<PMMLDocumentMetadata>>> callbackArgumentCaptor;
    private Definitions definitions;
    private PMMLDocumentMetadataProvider provider;

    @Before
    public void setup() {
        this.definitions = new Definitions();
        this.provider = new PMMLDocumentMetadataProvider(this.graphUtils, this.clientServicesProxy, this.sessionManager);
        ClientSession session = (ClientSession)Mockito.mock(ClientSession.class);
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getPath()).thenReturn((Object)this.dmnModelPath);
        Mockito.when((Object)this.graphUtils.getDefinitions(diagram)).thenReturn((Object)this.definitions);
    }

    @Test
    public void testLoadPMMLIncludedDocumentsDMNModelPath() {
        this.provider.loadPMMLIncludedDocuments();
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).loadPMMLDocumentsFromImports((Path)Matchers.eq((Object)this.dmnModelPath), Matchers.anyListOf(PMMLIncludedModel.class), (ServiceCallback)Matchers.any(ServiceCallback.class));
    }

    @Test
    public void testLoadPMMLIncludedDocumentsPMMLIncludedModels() {
        ImportDMN dmn = new ImportDMN("dmn", new LocationURI("dmn-location"), DMNImportTypes.DMN.getDefaultNamespace());
        ImportPMML pmml = new ImportPMML("pmml", new LocationURI("pmml-location"), DMNImportTypes.PMML.getDefaultNamespace());
        dmn.getName().setValue("dmn");
        pmml.getName().setValue("pmml");
        this.definitions.getImport().add(dmn);
        this.definitions.getImport().add(pmml);
        this.provider.loadPMMLIncludedDocuments();
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).loadPMMLDocumentsFromImports((Path)Matchers.any(Path.class), (List)this.pmmlIncludedModelsArgumentCaptor.capture(), (ServiceCallback)Matchers.any(ServiceCallback.class));
        List actualIncludedModels = (List)this.pmmlIncludedModelsArgumentCaptor.getValue();
        Assertions.assertThat((List)actualIncludedModels).hasSize(1);
        PMMLIncludedModel pmmlIncludedModel = (PMMLIncludedModel)actualIncludedModels.get(0);
        Assertions.assertThat((String)pmmlIncludedModel.getModelName()).isEqualTo((Object)"pmml");
        Assertions.assertThat((String)pmmlIncludedModel.getPath()).isEqualTo((Object)"pmml-location");
        Assertions.assertThat((String)pmmlIncludedModel.getImportType()).isEqualTo((Object)DMNImportTypes.PMML.getDefaultNamespace());
    }

    @Test
    public void testGetPMMLDocumentNames() {
        ArrayList<PMMLDocumentMetadata> pmmlDocuments = new ArrayList<PMMLDocumentMetadata>();
        pmmlDocuments.add(new PMMLDocumentMetadata("path1", "zDocument1", DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList()));
        pmmlDocuments.add(new PMMLDocumentMetadata("path2", "aDocument2", DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList()));
        ServiceCallback<List<PMMLDocumentMetadata>> callback = this.loadPMMLIncludedDocuments();
        callback.onSuccess(pmmlDocuments);
        List documentNames = this.provider.getPMMLDocumentNames();
        Assertions.assertThat((List)documentNames).containsSequence((Object[])new String[]{"aDocument2", "zDocument1"});
    }

    private ServiceCallback<List<PMMLDocumentMetadata>> loadPMMLIncludedDocuments() {
        this.provider.loadPMMLIncludedDocuments();
        ((DMNClientServicesProxy)Mockito.verify((Object)this.clientServicesProxy)).loadPMMLDocumentsFromImports((Path)Matchers.any(Path.class), Matchers.anyListOf(PMMLIncludedModel.class), (ServiceCallback)this.callbackArgumentCaptor.capture());
        return (ServiceCallback)this.callbackArgumentCaptor.getValue();
    }

    @Test
    public void testGetPMMLDocumentModelNames() {
        ArrayList<PMMLDocumentMetadata> pmmlDocuments = new ArrayList<PMMLDocumentMetadata>();
        pmmlDocuments.add(new PMMLDocumentMetadata("path", "document", DMNImportTypes.PMML.getDefaultNamespace(), Arrays.asList(new PMMLModelMetadata("zModel1", Collections.emptySet()), new PMMLModelMetadata("aModel2", Collections.emptySet()))));
        ServiceCallback<List<PMMLDocumentMetadata>> callback = this.loadPMMLIncludedDocuments();
        callback.onSuccess(pmmlDocuments);
        List modelNames = this.provider.getPMMLDocumentModels("document");
        Assertions.assertThat((List)modelNames).containsSequence((Object[])new String[]{"aModel2", "zModel1"});
        Assertions.assertThat((List)this.provider.getPMMLDocumentModels("unknown")).isEmpty();
    }

    @Test
    public void testGetPMMLDocumentModelParameterNames() {
        ArrayList<PMMLDocumentMetadata> pmmlDocuments = new ArrayList<PMMLDocumentMetadata>();
        pmmlDocuments.add(new PMMLDocumentMetadata("path", "document", DMNImportTypes.PMML.getDefaultNamespace(), Collections.singletonList(new PMMLModelMetadata("model", new Sets.Builder().add((Object)new PMMLParameterMetadata("zParameter1")).add((Object)new PMMLParameterMetadata("aParameter2")).build()))));
        ServiceCallback<List<PMMLDocumentMetadata>> callback = this.loadPMMLIncludedDocuments();
        callback.onSuccess(pmmlDocuments);
        List modelNames = this.provider.getPMMLDocumentModelParameterNames("document", "model");
        Assertions.assertThat((List)modelNames).containsSequence((Object[])new String[]{"aParameter2", "zParameter1"});
        Assertions.assertThat((List)this.provider.getPMMLDocumentModelParameterNames("unknown", "unknown")).isEmpty();
    }
}

