/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.literal;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionCell;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseDelegatingExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public abstract class BaseLiteralExpressionGridTest<G extends BaseDelegatingExpressionGrid<? extends LiteralExpression, DMNGridData, ? extends BaseUIModelMapper<? extends LiteralExpression>>> {
    private static final int PARENT_ROW_INDEX = 0;
    private static final int PARENT_COLUMN_INDEX = 1;
    protected static final String EXPRESSION_TEXT = "expression";
    protected static final String NODE_UUID = "uuid";
    protected static final String NAME = "name";
    protected GridCellTuple tupleWithoutValue;
    protected GridCellValueTuple tupleWithValue;
    @Mock
    protected DMNGridPanel gridPanel;
    @Mock
    protected DMNGridLayer gridLayer;
    @Mock
    protected GridWidget gridWidget;
    @Mock
    protected DefinitionUtils definitionUtils;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    protected DMNSession session;
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected Diagram diagram;
    @Mock
    protected Graph graph;
    @Mock
    protected Node node;
    @Mock
    protected Index index;
    @Mock
    protected Element element;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected TranslationService translationService;
    @Mock
    protected GridCellTuple parent;
    @Mock
    protected GridSelectionManager selectionManager;
    @Mock
    protected EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    protected EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    protected EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    protected NameAndDataTypePopoverView.Presenter headerEditor;
    @Captor
    protected ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    protected ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    protected Decision hasExpression = new Decision();
    protected Optional<? extends LiteralExpression> expression = Optional.empty();
    protected Optional<HasName> hasName = Optional.empty();
    protected BaseEditorDefinition<? extends LiteralExpression, DMNGridData> definition;
    protected GridWidget parentGridWidget;
    protected GridData parentGridUiModel;
    protected G grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.tupleWithoutValue = new GridCellTuple(0, 0, this.gridWidget);
        this.tupleWithValue = new GridCellValueTuple(0, 0, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        this.definition = this.getDefinition();
        Decision decision = new Decision();
        decision.setName(new Name(NAME));
        this.hasName = Optional.of(decision);
        this.expression = this.definition.getModelClass();
        this.expression.ifPresent(e -> e.getText().setValue(EXPRESSION_TEXT));
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn(Mockito.mock(Bounds.class));
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.index.get(Matchers.anyString())).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getContent()).thenReturn(Mockito.mock(Definition.class));
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(Matchers.any())).thenReturn((Object)NAME);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)Matchers.any(Element.class), Matchers.anyString(), Matchers.any())).thenReturn(Mockito.mock(UpdateElementPropertyCommand.class));
        this.parentGridWidget = this.getParentGridWidget();
        this.parentGridUiModel = this.getParentGridWidgetUiModel();
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridUiModel);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)1);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    protected abstract BaseEditorDefinition<? extends LiteralExpression, DMNGridData> getDefinition();

    protected abstract void setupGrid(int var1);

    protected GridWidget getParentGridWidget() {
        return (GridWidget)Mockito.mock(GridWidget.class);
    }

    protected GridData getParentGridWidgetUiModel() {
        return (GridData)Mockito.mock(GridData.class);
    }

    @Test
    public void testMouseDoubleClickEventHandlers() {
        this.setupGrid(0);
        List handlers = this.grid.getNodeMouseDoubleClickEventHandlers(this.selectionManager, (GridPinnedModeManager)this.gridLayer);
        Assertions.assertThat((List)handlers).hasSize(1);
        Assertions.assertThat(handlers.get(0)).isInstanceOf(DelegatingGridWidgetEditCellMouseEventHandler.class);
    }

    @Test
    public void testSelectFirstCellWhenNested() {
        this.setupGrid(1);
        this.grid.selectFirstCell();
        Assertions.assertThat((int)this.grid.getModel().getSelectedCells().size()).isEqualTo(0);
        ((GridData)Mockito.verify((Object)this.parentGridUiModel)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select(this.parentGridWidget);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.expression.get());
    }

    @Test
    public void testSelectFirstCellWhenNotNested() {
        this.setupGrid(0);
        this.grid.selectFirstCell();
        List selectedCells = this.grid.getModel().getSelectedCells();
        Assertions.assertThat((int)selectedCells.size()).isEqualTo(1);
        Assertions.assertThat((int)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex()).isEqualTo(0);
        Assertions.assertThat((int)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex()).isEqualTo(0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select(this.grid);
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.expression.get());
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(0);
        this.assertComponentWidths(100.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 200.0);
        this.setupGrid(0);
        this.assertComponentWidths(200.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testPaddingWithParent() {
        this.setupGrid(0);
        ((BaseDelegatingExpressionGrid)Mockito.doReturn(Optional.of(Mockito.mock(BaseExpressionGrid.class))).when(this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(0.0);
    }

    @Test
    public void testPaddingWithNoParent() {
        this.setupGrid(0);
        ((BaseDelegatingExpressionGrid)Mockito.doReturn(Optional.empty()).when(this.grid)).findParentGrid();
        Assertions.assertThat((double)this.grid.getPadding()).isEqualTo(10.0);
    }

    @Test
    public void testGetItemsWithNoParent() {
        this.setupGrid(0);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn(Mockito.mock(GridWidget.class));
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(Mockito.mock(BaseGridWidget.class)));
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testGetItemsWithParentThatDoesSupportCellControls() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        ContextGrid parentGridWidget = (ContextGrid)Mockito.mock(ContextGrid.class);
        HasListSelectorControl.ListSelectorItem listSelectorItem = (HasListSelectorControl.ListSelectorItem)Mockito.mock(HasListSelectorControl.ListSelectorItem.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        Mockito.when((Object)parentGridWidget.getItems(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Collections.singletonList(listSelectorItem));
        Mockito.when((Object)parentGridData.getCell(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Mockito.mock(LiteralExpressionCell.class));
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isNotEmpty();
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        Assertions.assertThat(items.get(0)).isSameAs((Object)listSelectorItem);
    }

    @Test
    public void testGetItemsWithParentThatDoesSupportCellControlsButCellDoesNot() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        ContextGrid parentGridWidget = (ContextGrid)Mockito.mock(ContextGrid.class);
        HasListSelectorControl.ListSelectorItem listSelectorItem = (HasListSelectorControl.ListSelectorItem)Mockito.mock(HasListSelectorControl.ListSelectorItem.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        Mockito.when((Object)parentGridWidget.getItems(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Collections.singletonList(listSelectorItem));
        Mockito.when((Object)parentGridData.getCell(Matchers.anyInt(), Matchers.anyInt())).thenReturn(Mockito.mock(BaseGridCell.class));
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testGetItemsWithParentThatDoesNotSupportCellControls() {
        this.setupGrid(0);
        GridData parentGridData = (GridData)Mockito.mock(GridData.class);
        BaseExpressionGrid parentGridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)parentGridWidget);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(parentGridWidget));
        Mockito.when((Object)parentGridWidget.getModel()).thenReturn((Object)parentGridData);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }
}

