/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationUIModelMapperTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiRelationColumn1;
    @Mock
    private RelationColumn uiRelationColumn2;
    @Mock
    private ListSelectorView.Presenter listSelector;
    private BaseGridData uiModel;
    private Relation relation;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private RelationUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiRelationColumn1);
        this.uiModel.appendColumn((GridColumn)this.uiRelationColumn2);
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiRelationColumn1.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.uiRelationColumn2.getIndex()).thenReturn((Object)2);
        this.relation = new Relation();
        this.relation.getColumn().add(new InformationItem());
        this.relation.getColumn().add(new InformationItem());
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("le(1,0)");
                    }
                });
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("le(2,0)");
                    }
                });
            }
        });
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("le(1,1)");
                    }
                });
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.getText().setValue("le(2,1)");
                    }
                });
            }
        });
        this.mapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation), this.listSelector);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.mapper.fromDMNModel(0, 0);
        this.mapper.fromDMNModel(1, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)RowSelectionStrategy.INSTANCE, (Object)this.uiModel.getCell(0, 0).getSelectionStrategy());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)RowSelectionStrategy.INSTANCE, (Object)this.uiModel.getCell(1, 0).getSelectionStrategy());
    }

    @Test
    public void testFromDMNModelLiteralExpressions() {
        this.mapper.fromDMNModel(0, 1);
        this.mapper.fromDMNModel(0, 2);
        this.mapper.fromDMNModel(1, 1);
        this.mapper.fromDMNModel(1, 2);
        Assert.assertEquals((Object)"le(1,0)", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"le(2,0)", (Object)this.uiModel.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"le(1,1)", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"le(2,1)", (Object)this.uiModel.getCell(1, 2).getValue().getValue());
    }

    @Test
    public void testFromDMNModelCellTypes() {
        IntStream.range(0, 2).forEach(rowIndex -> {
            this.mapper.fromDMNModel(rowIndex, 0);
            this.mapper.fromDMNModel(rowIndex, 1);
            this.mapper.fromDMNModel(rowIndex, 2);
        });
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0)).isInstanceOf(RelationGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 1)).isInstanceOf(RelationGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 2)).isInstanceOf(RelationGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 0)).isInstanceOf(RelationGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 1)).isInstanceOf(RelationGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(1, 2)).isInstanceOf(RelationGridCell.class);
    }

    @Test
    public void testToDMNModelLiteralExpressionsNullValue() {
        this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue(null));
        for (int uiRowIndex = 0; uiRowIndex < this.uiModel.getRowCount(); ++uiRowIndex) {
            for (int uiColumnIndex = 1; uiColumnIndex < this.uiModel.getColumnCount(); ++uiColumnIndex) {
                this.mapper.toDMNModel(uiRowIndex, uiColumnIndex, this.cellValueSupplier);
                LiteralExpression le = (LiteralExpression)((List)this.relation.getRow().get(uiRowIndex)).getExpression().get(uiColumnIndex - 1);
                Assert.assertNull((Object)le.getText().getValue());
            }
        }
    }

    @Test
    public void testToDMNModelLiteralExpressionsEmptyValue() {
        for (int uiRowIndex = 0; uiRowIndex < this.uiModel.getRowCount(); ++uiRowIndex) {
            for (int uiColumnIndex = 1; uiColumnIndex < this.uiModel.getColumnCount(); ++uiColumnIndex) {
                this.mapper.toDMNModel(uiRowIndex, uiColumnIndex, this.cellValueSupplier);
                LiteralExpression le = (LiteralExpression)((List)this.relation.getRow().get(uiRowIndex)).getExpression().get(uiColumnIndex - 1);
                Assert.assertEquals((Object)"", (Object)le.getText().getValue());
            }
        }
    }

    @Test
    public void testToDMNModelLiteralExpressionsNonEmptyValue() {
        for (int uiRowIndex = 0; uiRowIndex < this.uiModel.getRowCount(); ++uiRowIndex) {
            for (int uiColumnIndex = 1; uiColumnIndex < this.uiModel.getColumnCount(); ++uiColumnIndex) {
                String value = "(" + uiColumnIndex + "," + uiRowIndex + ")";
                this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)value));
                this.mapper.toDMNModel(uiRowIndex, uiColumnIndex, this.cellValueSupplier);
                LiteralExpression le = (LiteralExpression)((List)this.relation.getRow().get(uiRowIndex)).getExpression().get(uiColumnIndex - 1);
                Assert.assertEquals((Object)value, (Object)le.getText().getValue());
            }
        }
    }
}

