/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectionUtilsTest {
    @Mock
    private GridColumn uiColumn0;
    @Mock
    private GridColumn uiColumn1;
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    private GridData uiModel;

    @Before
    public void setup() {
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn(this.uiColumn0);
        this.uiModel.appendColumn(this.uiColumn1);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        Mockito.when((Object)this.uiColumn0.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiColumn1.getIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.uiColumn0.getHeaderMetaData()).thenReturn(Collections.singletonList(this.headerMetaData));
        Mockito.when((Object)this.uiColumn1.getHeaderMetaData()).thenReturn(Collections.singletonList(this.headerMetaData));
    }

    @Test
    public void testIsMultiSelectZeroSelections() {
        Assertions.assertThat((boolean)SelectionUtils.isMultiSelect((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiSelectSingleSelection() {
        this.uiModel.selectCell(0, 0);
        Assertions.assertThat((boolean)SelectionUtils.isMultiSelect((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiSelectMultipleSelections() {
        this.uiModel.selectCell(0, 0);
        this.uiModel.selectCell(0, 1);
        Assertions.assertThat((boolean)SelectionUtils.isMultiSelect((GridData)this.uiModel)).isTrue();
    }

    @Test
    public void testIsMultiRowZeroSelections() {
        Assertions.assertThat((boolean)SelectionUtils.isMultiRow((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiRowSingleSelection() {
        this.uiModel.selectCell(0, 0);
        Assertions.assertThat((boolean)SelectionUtils.isMultiRow((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiRowMultipleSelections() {
        this.uiModel.selectCell(0, 0);
        this.uiModel.selectCell(1, 0);
        Assertions.assertThat((boolean)SelectionUtils.isMultiRow((GridData)this.uiModel)).isTrue();
    }

    @Test
    public void testIsMultiColumnZeroSelections() {
        Assertions.assertThat((boolean)SelectionUtils.isMultiColumn((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiColumnSingleSelection() {
        this.uiModel.selectCell(0, 0);
        Assertions.assertThat((boolean)SelectionUtils.isMultiColumn((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiColumnMultipleSelections() {
        this.uiModel.selectCell(0, 0);
        this.uiModel.selectCell(0, 1);
        Assertions.assertThat((boolean)SelectionUtils.isMultiColumn((GridData)this.uiModel)).isTrue();
    }

    @Test
    public void testIsMultiHeaderColumnZeroSelections() {
        Assertions.assertThat((boolean)SelectionUtils.isMultiHeaderColumn((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiHeaderColumnSingleSelection() {
        this.uiModel.selectHeaderCell(0, 0);
        Assertions.assertThat((boolean)SelectionUtils.isMultiHeaderColumn((GridData)this.uiModel)).isFalse();
    }

    @Test
    public void testIsMultiHeaderColumnMultipleSelections() {
        this.uiModel.selectHeaderCell(0, 0);
        this.uiModel.selectHeaderCell(0, 1);
        Assertions.assertThat((boolean)SelectionUtils.isMultiHeaderColumn((GridData)this.uiModel)).isTrue();
    }
}

