/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import com.google.gwt.dom.client.Style;
import elemental2.dom.HTMLElement;
import java.util.Collections;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.decision.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.grid.BaseCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardsGridComponent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

public abstract class BaseCardComponentTest<C extends BaseCardComponent<R, V>, V extends BaseCardComponent.ContentView, R extends BaseIncludedModelActiveRecord> {
    @Mock
    protected EventSourceMock<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    protected C card;
    protected V cardView;

    @Before
    public void setup() {
        this.cardView = this.getCardView();
        this.card = (BaseCardComponent)Mockito.spy(this.getCard(this.cardView));
    }

    protected abstract V getCardView();

    protected abstract C getCard(V var1);

    protected abstract Class<R> getActiveRecordClass();

    @Test
    public void testInit() {
        this.card.init();
        ((BaseCardComponent.ContentView)Mockito.verify(this.cardView)).init(this.card);
    }

    @Test
    public void testSetup() {
        DMNCardsGridComponent expectedGrid = (DMNCardsGridComponent)Mockito.mock(DMNCardsGridComponent.class);
        BaseIncludedModelActiveRecord expectedIncludedModel = (BaseIncludedModelActiveRecord)Mockito.mock(this.getActiveRecordClass());
        Mockito.when((Object)expectedIncludedModel.getNamespace()).thenReturn((Object)"://namespace");
        this.card.setup(expectedGrid, expectedIncludedModel);
        DMNCardsGridComponent actualGrid = this.card.getGrid();
        BaseIncludedModelActiveRecord actualIncludedModel = this.card.getIncludedModel();
        ((BaseCardComponent)Mockito.verify(this.card)).refreshView();
        Assert.assertEquals((Object)expectedGrid, (Object)actualGrid);
        Assert.assertEquals((Object)expectedIncludedModel, (Object)actualIncludedModel);
    }

    @Test
    public void testRefreshView() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String path = "/bla/bla/bla/111111111111111222222222222222333333333333333444444444444444/file.dmn";
        Mockito.when((Object)includedModel.getNamespace()).thenReturn((Object)"/bla/bla/bla/111111111111111222222222222222333333333333333444444444444444/file.dmn");
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        this.card.refreshView();
        ((BaseCardComponent.ContentView)Mockito.verify(this.cardView)).setPath("...111111222222222222222333333333333333444444444444444/file.dmn");
    }

    @Test
    public void testGetIcon() {
        IconType expected = IconType.DOWNLOAD;
        Style.HasCssName actual = this.card.getIcon();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetTitle() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String expectedTitle = "file";
        Mockito.when((Object)includedModel.getName()).thenReturn((Object)"file");
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        String actualTitle = this.card.getTitle();
        Assert.assertEquals((Object)"file", (Object)actualTitle);
    }

    @Test
    public void testGetUUID() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String expectedUUID = "123";
        Mockito.when((Object)includedModel.getUUID()).thenReturn((Object)"123");
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        String actualUUID = this.card.getUUID();
        Assert.assertEquals((Object)"123", (Object)actualUUID);
    }

    @Test
    public void testGetContent() {
        HTMLElement expectedContent = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.cardView.getElement()).thenReturn((Object)expectedContent);
        HTMLElement actualContent = this.card.getContent();
        Assert.assertEquals((Object)expectedContent, (Object)actualContent);
    }

    @Test
    public void testOnTitleChangedWhenIncludedModelIsValid() {
        DMNCardsGridComponent grid = (DMNCardsGridComponent)Mockito.mock(DMNCardsGridComponent.class);
        DMNIncludedModelActiveRecord includedModel = (DMNIncludedModelActiveRecord)Mockito.spy((Object)new DMNIncludedModelActiveRecord(null));
        String newName = "newName";
        ((DMNIncludedModelActiveRecord)Mockito.doReturn((Object)true).when((Object)includedModel)).isValid();
        ((DMNIncludedModelActiveRecord)Mockito.doReturn(Collections.emptyList()).when((Object)includedModel)).update();
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        ((BaseCardComponent)Mockito.doReturn((Object)grid).when(this.card)).getGrid();
        boolean titleChanged = (Boolean)this.card.onTitleChanged().apply("newName");
        Assert.assertEquals((Object)"newName", (Object)includedModel.getName());
        Assert.assertTrue((boolean)titleChanged);
        ((DMNIncludedModelActiveRecord)Mockito.verify((Object)includedModel)).update();
        ((DMNCardsGridComponent)Mockito.verify((Object)grid)).refresh();
        ((BaseCardComponent)Mockito.verify(this.card)).refreshDecisionComponents();
    }

    @Test
    public void testOnTitleChangedWhenIncludedModelIsNotValid() {
        DMNCardsGridComponent grid = (DMNCardsGridComponent)Mockito.mock(DMNCardsGridComponent.class);
        DMNIncludedModelActiveRecord includedModel = (DMNIncludedModelActiveRecord)Mockito.spy((Object)new DMNIncludedModelActiveRecord(null));
        String newName = "newName";
        String oldName = "oldName";
        includedModel.setName("oldName");
        ((DMNIncludedModelActiveRecord)Mockito.doReturn((Object)false).when((Object)includedModel)).isValid();
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        ((BaseCardComponent)Mockito.doReturn((Object)grid).when(this.card)).getGrid();
        boolean titleChanged = (Boolean)this.card.onTitleChanged().apply("newName");
        Assert.assertEquals((Object)"oldName", (Object)includedModel.getName());
        Assert.assertFalse((boolean)titleChanged);
        ((DMNIncludedModelActiveRecord)Mockito.verify((Object)includedModel, (VerificationMode)Mockito.never())).update();
        ((DMNCardsGridComponent)Mockito.verify((Object)grid, (VerificationMode)Mockito.never())).refresh();
        ((BaseCardComponent)Mockito.verify(this.card, (VerificationMode)Mockito.never())).refreshDecisionComponents();
    }

    @Test
    public void testTruncateWhenItIsTruncated() {
        String actualTruncate = this.card.truncate("123456", 5);
        String expectedTruncate = "...23456";
        Assert.assertEquals((Object)"...23456", (Object)actualTruncate);
    }

    @Test
    public void testTruncateWhenItIsNotTruncated() {
        String actualTruncate = this.card.truncate("12345", 5);
        String expectedTruncate = "12345";
        Assert.assertEquals((Object)"12345", (Object)actualTruncate);
    }

    @Test
    public void testRemove() {
        DMNCardsGridComponent grid = (DMNCardsGridComponent)Mockito.mock(DMNCardsGridComponent.class);
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        ((BaseCardComponent)Mockito.doReturn((Object)grid).when(this.card)).getGrid();
        this.card.remove();
        ((BaseIncludedModelActiveRecord)Mockito.verify((Object)includedModel)).destroy();
        ((DMNCardsGridComponent)Mockito.verify((Object)grid)).refresh();
        ((EventSourceMock)Mockito.verify(this.refreshDecisionComponentsEvent)).fire(Matchers.any(RefreshDecisionComponents.class));
    }

    @Test
    public void testGetSubTitleWhenPathIsNotEmpty() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String expected = "/src/path/kie/dmn";
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        Mockito.when((Object)includedModel.getPath()).thenReturn((Object)"/src/path/kie/dmn");
        String actual = this.card.getSubTitle();
        Assert.assertEquals((Object)"/src/path/kie/dmn", (Object)actual);
    }

    @Test
    public void testGetSubTitleWhenPathIsEmpty() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String expected = "://namespace";
        ((BaseCardComponent)Mockito.doReturn((Object)includedModel).when(this.card)).getIncludedModel();
        Mockito.when((Object)includedModel.getPath()).thenReturn((Object)"");
        Mockito.when((Object)includedModel.getNamespace()).thenReturn((Object)"://namespace");
        String actual = this.card.getSubTitle();
        Assert.assertEquals((Object)"://namespace", (Object)actual);
    }
}

