/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.search.DMNDataTypesSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDataTypesSubIndexTest {
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DataTypeShortcuts dataTypeShortcuts;
    @Mock
    private DataTypeStore dataTypeStore;
    private DMNDataTypesSubIndex index;

    @Before
    public void setup() {
        this.index = (DMNDataTypesSubIndex)Mockito.spy((Object)new DMNDataTypesSubIndex(this.dataTypeList, this.dataTypeShortcuts, this.dataTypeStore));
    }

    @Test
    public void testGetSearchableElements() {
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        String dataTypeName1 = "data type 1";
        String dataTypeName2 = "data type 2";
        String dataTypeName3 = "data type 3";
        HTMLElement htmlElement1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement htmlElement2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement htmlElement3 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<DataTypeListItem> dataTypeListItems = Arrays.asList(listItem1, listItem2, listItem3);
        Mockito.when((Object)listItem1.getElement()).thenReturn((Object)htmlElement1);
        Mockito.when((Object)listItem2.getElement()).thenReturn((Object)htmlElement2);
        Mockito.when((Object)listItem3.getElement()).thenReturn((Object)htmlElement3);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem3.getDataType()).thenReturn((Object)dataType3);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"data type 1");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"data type 2");
        Mockito.when((Object)dataType3.getName()).thenReturn((Object)"data type 3");
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(dataTypeListItems);
        List elements = this.index.getSearchableElements();
        DMNSearchableElement element1 = (DMNSearchableElement)elements.get(0);
        DMNSearchableElement element2 = (DMNSearchableElement)elements.get(1);
        DMNSearchableElement element3 = (DMNSearchableElement)elements.get(2);
        elements.forEach(e -> e.onFound().execute());
        Assert.assertEquals((long)3L, (long)elements.size());
        Assert.assertEquals((Object)"data type 1", (Object)element1.getText());
        Assert.assertEquals((Object)"data type 2", (Object)element2.getText());
        Assert.assertEquals((Object)"data type 3", (Object)element3.getText());
        ((DMNDataTypesSubIndex)Mockito.verify((Object)this.index)).highlight(listItem1);
        ((DMNDataTypesSubIndex)Mockito.verify((Object)this.index)).highlight(listItem2);
        ((DMNDataTypesSubIndex)Mockito.verify((Object)this.index)).highlight(listItem3);
    }

    @Test
    public void testOnNoResultsFound() {
        this.index.onNoResultsFound();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).reset();
    }

    @Test
    public void testHighlight() {
        DataTypeListItem listItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem parentListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType parent = (DataType)Mockito.mock(DataType.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        String parentUUID = "parentUUID";
        String dataTypeUUID = "dataTypeUUID";
        Mockito.when((Object)listItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)parentListItem.getDataType()).thenReturn((Object)parent);
        Mockito.when((Object)listItem.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"dataTypeUUID");
        Mockito.when((Object)parent.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.dataTypeStore.get("parentUUID")).thenReturn((Object)parent);
        Mockito.when((Object)this.dataTypeStore.get("dataTypeUUID")).thenReturn((Object)dataType);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(Arrays.asList(listItem, parentListItem));
        this.index.highlight(listItem);
        ((DataTypeListItem)Mockito.verify((Object)listItem)).expand();
        ((DataTypeListItem)Mockito.verify((Object)parentListItem)).expand();
        ((DataTypeShortcuts)Mockito.verify((Object)this.dataTypeShortcuts)).highlight((Element)htmlElement);
    }
}

