/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BootstrapSelectDropDownMonitorTest {
    private static final Optional<String> TITLE = Optional.of("title");
    @Mock
    private JQuerySelectPicker jQuerySelectPicker;
    @Mock
    private JQuerySelectPickerEvent event;
    @Mock
    private ParameterizedCommand<Optional<String>> showCommand;
    @Mock
    private Command hideCommand;
    @Captor
    private ArgumentCaptor<JQuerySelectPicker.CallbackFunction> shownCallbackHandlerCaptor;
    @Captor
    private ArgumentCaptor<JQuerySelectPicker.CallbackFunction> hiddenCallbackHandlerCaptor;
    private NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor;

    @Before
    public void setup() {
        this.monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.spy((Object)new NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor(this.showCommand, this.hideCommand));
        Mockito.when((Object)this.monitor.kieDataTypeSelect()).thenReturn((Object)this.jQuerySelectPicker);
    }

    @Test
    public void testShow() {
        this.monitor.show(TITLE);
        ((ParameterizedCommand)Mockito.verify(this.showCommand)).execute(Matchers.eq(TITLE));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"shown.bs.select"), (JQuerySelectPicker.CallbackFunction)Matchers.any(JQuerySelectPicker.CallbackFunction.class));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"hidden.bs.select"), (JQuerySelectPicker.CallbackFunction)Matchers.any(JQuerySelectPicker.CallbackFunction.class));
        Assertions.assertThat((boolean)this.monitor.isSelectDropDownShown).isFalse();
    }

    @Test
    public void testShowEventSetup() {
        this.monitor.show(TITLE);
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"shown.bs.select"), (JQuerySelectPicker.CallbackFunction)this.shownCallbackHandlerCaptor.capture());
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"hidden.bs.select"), (JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.capture());
        ((JQuerySelectPicker.CallbackFunction)this.shownCallbackHandlerCaptor.getValue()).call(this.event);
        Assertions.assertThat((boolean)this.monitor.isSelectDropDownShown).isTrue();
        ((JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.getValue()).call(this.event);
        Assertions.assertThat((boolean)this.monitor.isSelectDropDownShown).isFalse();
    }

    @Test
    public void testHideWhenDropDownIsShown() {
        this.monitor.show(TITLE);
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"shown.bs.select"), (JQuerySelectPicker.CallbackFunction)this.shownCallbackHandlerCaptor.capture());
        ((JQuerySelectPicker.CallbackFunction)this.shownCallbackHandlerCaptor.getValue()).call(this.event);
        Mockito.reset((Object[])new JQuerySelectPicker[]{this.jQuerySelectPicker});
        this.monitor.hide();
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)Matchers.eq((Object)"shown.bs.select"));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).on((String)Matchers.eq((Object)"hidden.bs.select"), (JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.capture());
        ((Command)Mockito.verify((Object)this.hideCommand, (VerificationMode)Mockito.never())).execute();
        ((JQuerySelectPicker.CallbackFunction)this.hiddenCallbackHandlerCaptor.getValue()).call(this.event);
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)Matchers.eq((Object)"hidden.bs.select"));
        ((Command)Mockito.verify((Object)this.hideCommand)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jQuerySelectPicker});
    }

    @Test
    public void testHideWhenDropDownIsNotShown() {
        this.monitor.show(TITLE);
        Mockito.reset((Object[])new JQuerySelectPicker[]{this.jQuerySelectPicker});
        this.monitor.hide();
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)Matchers.eq((Object)"shown.bs.select"));
        ((JQuerySelectPicker)Mockito.verify((Object)this.jQuerySelectPicker)).off((String)Matchers.eq((Object)"hidden.bs.select"));
        ((Command)Mockito.verify((Object)this.hideCommand)).execute();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jQuerySelectPicker});
    }
}

