/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverImpl;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NameAndDataTypePopoverImplTest {
    private static final String NAME = "name";
    @Mock
    private NameAndDataTypePopoverView view;
    @Mock
    private HasNameAndTypeRef bound;
    @Mock
    private Decision decision;
    @Mock
    private QName typeRef;
    private NameAndDataTypePopoverView.Presenter editor;

    @Before
    public void setup() {
        this.editor = new NameAndDataTypePopoverImpl(this.view);
        Mockito.when((Object)this.bound.asDMNModelInstrumentedBase()).thenReturn((Object)this.decision);
        Mockito.when((Object)this.bound.getName()).thenReturn((Object)new Name(NAME));
        Mockito.when((Object)this.bound.getTypeRef()).thenReturn((Object)this.typeRef);
    }

    @Test
    public void testInit() {
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.editor));
    }

    @Test
    public void testShow() {
        this.editor.bind((Object)this.bound, 0, 0);
        this.editor.show(Optional.empty());
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).show(Optional.empty());
    }

    @Test
    public void testHide() {
        this.editor.bind((Object)this.bound, 0, 0);
        this.editor.hide();
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testBind() {
        this.editor.bind((Object)this.bound, 0, 0);
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.decision));
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).initName((String)Matchers.eq((Object)NAME));
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).initSelectedTypeRef((QName)Matchers.eq((Object)this.typeRef));
        this.editor.show(Optional.empty());
        ((NameAndDataTypePopoverView)Mockito.verify((Object)this.view)).show(Optional.empty());
    }

    @Test
    public void testSetDisplayName() {
        this.editor.bind((Object)this.bound, 0, 0);
        this.editor.setName(NAME);
        ((HasNameAndTypeRef)Mockito.verify((Object)this.bound)).setName((Name)Matchers.eq((Object)new Name(NAME)));
    }

    @Test
    public void testSetTypeRef() {
        this.editor.bind((Object)this.bound, 0, 0);
        this.editor.setTypeRef(this.typeRef);
        ((HasNameAndTypeRef)Mockito.verify((Object)this.bound)).setTypeRef((QName)Matchers.eq((Object)this.typeRef));
    }
}

