/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;

@RunWith(value=GwtMockitoTestRunner.class)
public class NameAndDataTypePopoverViewImplTest {
    private static final String NAME = "name";
    @Mock
    private Input nameEditor;
    @Mock
    private DataTypePickerWidget dataTypeEditor;
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private Span nameLabel;
    @Mock
    private Span dataTypeLabel;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryProducer;
    @Mock
    private NameAndDataTypePopoverView.Presenter presenter;
    @Mock
    private HTMLElement element;
    @Mock
    private Decision decision;
    @Mock
    private QName typeRef;
    @Mock
    private ValueChangeEvent<QName> valueChangeEvent;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private Popover popover;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<ValueChangeHandler<QName>> valueChangeHandlerCaptor;
    private NameAndDataTypePopoverViewImpl view;

    @Before
    public void setUp() {
        this.view = (NameAndDataTypePopoverViewImpl)Mockito.spy((Object)new NameAndDataTypePopoverViewImpl(this.nameEditor, this.dataTypeEditor, this.popoverElement, this.popoverContentElement, this.nameLabel, this.dataTypeLabel, this.jQueryProducer, this.translationService){

            public HTMLElement getElement() {
                return NameAndDataTypePopoverViewImplTest.this.element;
            }
        });
        this.view.init(this.presenter);
        Mockito.when((Object)this.valueChangeEvent.getValue()).thenReturn((Object)this.typeRef);
        Mockito.when((Object)this.jQueryProducer.wrap((Element)this.element)).thenReturn((Object)this.popover);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    @Test
    public void testInit() {
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerCaptor.getValue()).onValueChange(this.valueChangeEvent);
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.presenter)).setTypeRef((QName)Matchers.eq((Object)this.typeRef));
    }

    @Test
    public void testSetDMNModel() {
        this.view.setDMNModel((DMNModelInstrumentedBase)this.decision);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.decision));
    }

    @Test
    public void testInitName() {
        this.view.initName(NAME);
        ((Input)Mockito.verify((Object)this.nameEditor)).setValue((String)Matchers.eq((Object)NAME));
    }

    @Test
    public void testInitSelectedTypeRef() {
        this.view.initSelectedTypeRef(this.typeRef);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setValue((QName)Matchers.eq((Object)this.typeRef), Matchers.eq((boolean)false));
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((Popover)Mockito.verify((Object)this.popover)).show();
    }

    @Test
    public void testHideBeforeShown() {
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHideAfterShown() {
        this.view.show(Optional.empty());
        this.view.hide();
        ((Input)Mockito.verify((Object)this.nameEditor)).blur();
        ((Popover)Mockito.verify((Object)this.popover)).hide();
        ((Popover)Mockito.verify((Object)this.popover)).destroy();
    }

    @Test
    public void testOnNameChange() {
        Mockito.when((Object)this.nameEditor.getValue()).thenReturn((Object)NAME);
        this.view.onNameChange(this.blurEvent);
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.presenter)).setName((String)Matchers.eq((Object)NAME));
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        this.view.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide();
    }
}

