/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common.errors;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.ErrorMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ErrorMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetFlashMessage() {
        String uuid = "uuid";
        FlashMessage.Type expectedType = FlashMessage.Type.ERROR;
        String expectedStrongMessage = "expectedStrongMessage";
        String expectedRegularMessage = "expectedRegularMessage";
        String expectedErrorElementSelector = "[data-row-uuid=\"uuid\"] [data-type-field=\"name-input\"]";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ErrorMessage errorMessage = new ErrorMessage(this.translationService){

            String getStrongMessage(DataType dataType) {
                return "expectedStrongMessage";
            }

            String getRegularMessage() {
                return "expectedRegularMessage";
            }
        };
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        FlashMessage flashMessage = errorMessage.getFlashMessage(dataType);
        FlashMessage.Type actualType = flashMessage.getType();
        String actualStrongMessage = flashMessage.getStrongMessage();
        String actualRegularMessage = flashMessage.getRegularMessage();
        String actualErrorElementSelector = flashMessage.getElementSelector();
        Assert.assertEquals((Object)expectedType, (Object)actualType);
        Assert.assertEquals((Object)"expectedStrongMessage", (Object)actualStrongMessage);
        Assert.assertEquals((Object)"expectedRegularMessage", (Object)actualRegularMessage);
        Assert.assertEquals((Object)"[data-row-uuid=\"uuid\"] [data-type-field=\"name-input\"]", (Object)actualErrorElementSelector);
    }
}

