/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.confirmation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.WarningMessage;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class WarningMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetFlashMessage() {
        String uuid = "uuid";
        FlashMessage.Type expectedType = FlashMessage.Type.WARNING;
        String expectedStrongMessage = "expectedStrongMessage";
        String expectedRegularMessage = "expectedRegularMessage";
        String expectedErrorElementSelector = "[data-row-uuid=\"uuid\"] .bootstrap-select";
        Command expectedOnSuccessCallback = (Command)Mockito.mock(Command.class);
        Command expectedOnErrorCallback = (Command)Mockito.mock(Command.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        WarningMessage errorMessage = new WarningMessage(this.translationService){

            String getStrongMessage(DataType dataType) {
                return "expectedStrongMessage";
            }

            String getRegularMessage() {
                return "expectedRegularMessage";
            }
        };
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        FlashMessage flashMessage = errorMessage.getFlashMessage(dataType, expectedOnSuccessCallback, expectedOnErrorCallback);
        FlashMessage.Type actualType = flashMessage.getType();
        String actualStrongMessage = flashMessage.getStrongMessage();
        String actualRegularMessage = flashMessage.getRegularMessage();
        String actualErrorElementSelector = flashMessage.getElementSelector();
        Command actualOnSuccessCallback = flashMessage.getOnSuccess();
        Command actualOnErrorCallback = flashMessage.getOnError();
        Assert.assertEquals((Object)expectedType, (Object)actualType);
        Assert.assertEquals((Object)"expectedStrongMessage", (Object)actualStrongMessage);
        Assert.assertEquals((Object)"expectedRegularMessage", (Object)actualRegularMessage);
        Assert.assertEquals((Object)"[data-row-uuid=\"uuid\"] .bootstrap-select", (Object)actualErrorElementSelector);
        Assert.assertEquals((Object)expectedOnSuccessCallback, (Object)actualOnSuccessCallback);
        Assert.assertEquals((Object)expectedOnErrorCallback, (Object)actualOnErrorCallback);
    }
}

