/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintViewTest {
    @Mock
    private HTMLAnchorElement constraintsAnchor;
    @Mock
    private HTMLElement constraintsTooltip;
    @Mock
    private HTMLElement constraintsLabel;
    @Mock
    private HTMLDivElement constraintsText;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataTypeConstraint presenter;
    private DataTypeConstraintView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintView)Mockito.spy((Object)new DataTypeConstraintView(this.constraintsAnchor, this.constraintsTooltip, this.constraintsLabel, this.constraintsText, this.translationService));
        this.view.init(this.presenter);
    }

    @Test
    public void testSetup() {
        String constraintsTooltipText = "ConstraintsTooltip";
        JSONObject properties = (JSONObject)Mockito.mock(JSONObject.class);
        JavaScriptObject propertiesJSONObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)properties).when((Object)this.view)).properties();
        Mockito.when((Object)properties.getJavaScriptObject()).thenReturn((Object)propertiesJSONObject);
        Mockito.when((Object)this.translationService.format("DataTypeConstraintView.ConstraintsTooltip", new Object[0])).thenReturn((Object)"ConstraintsTooltip");
        this.view.setup();
        ((HTMLElement)Mockito.verify((Object)this.constraintsTooltip)).setAttribute("title", "ConstraintsTooltip");
        ((DataTypeConstraintView)Mockito.verify((Object)this.view)).setupTooltip(propertiesJSONObject);
    }

    @Test
    public void testOnConstraintsClick() {
        this.view.onConstraintsClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraint)Mockito.verify((Object)this.presenter)).openModal();
    }

    @Test
    public void testShowAnchor() {
        this.constraintsAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsTooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showAnchor();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsAnchor.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsTooltip.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testShowTextLabel() {
        this.constraintsLabel.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showTextLabel();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsLabel.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideAnchor() {
        this.constraintsAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsTooltip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideAnchor();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsAnchor.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.constraintsTooltip.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testHideTextLabel() {
        this.constraintsLabel.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideTextLabel();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsLabel.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowText() {
        this.constraintsText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showText();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsText.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideText() {
        this.constraintsText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideText();
        ((DOMTokenList)Mockito.verify((Object)this.constraintsText.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testSetTextWhenTextIsNotBlank() {
        String expectedText = "text";
        this.constraintsText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsText.textContent = "something";
        this.view.setText("text");
        String actualText = this.constraintsText.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.constraintsText.classList)).remove(new String[]{"none"});
        Assert.assertEquals((Object)"text", (Object)actualText);
    }

    @Test
    public void testSetTextWhenTextIsBlank() {
        this.constraintsText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.constraintsText.textContent = "something";
        this.view.setText("");
        String expectedText = "NONE";
        String actualText = this.constraintsText.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.constraintsText.classList)).add(new String[]{"none"});
        Assert.assertEquals((Object)"NONE", (Object)actualText);
    }

    @Test
    public void testProperties() {
        JSONObject jsonObject = (JSONObject)Mockito.mock(JSONObject.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)jsonObject).when((Object)this.view)).makeJsonObject();
        this.view.properties();
        ((JSONObject)Mockito.verify((Object)jsonObject)).put((String)Matchers.eq((Object)"container"), (JSONValue)Matchers.eq((Object)new JSONString("body")));
    }

    @Test
    public void testEnable() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.enable();
        element.classList.remove(new String[]{"hidden"});
    }

    @Test
    public void testDisable() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.disable();
        element.classList.add(new String[]{"hidden"});
    }
}

