/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.BaseSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.BaseSelectorView;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseSelectorViewTest {
    @Mock
    private HTMLInputElement input;
    @Mock
    private Consumer<BlurEvent> blurEventConsumer;
    @Mock
    private Consumer<Event> eventConsumer;
    @Mock
    private BaseSelector presenter;
    private BaseSelectorView selectorView;

    @Before
    public void setup() {
        this.selectorView = (BaseSelectorView)Mockito.spy((Object)new BaseSelectorView(this.input));
        this.selectorView.init(this.presenter);
    }

    @Test
    public void testGetValue() {
        String expected = "expected";
        this.input.value = "expected";
        String actual = this.selectorView.getValue();
        Assert.assertEquals((Object)"expected", (Object)actual);
    }

    @Test
    public void testSetValue() {
        String expected = "expected";
        this.input.value = "something";
        this.selectorView.setValue("expected");
        String actual = this.input.value;
        Assert.assertEquals((Object)"expected", (Object)actual);
    }

    @Test
    public void testSetPlaceholder() {
        String attribute = "placeholder";
        String value = "value";
        this.selectorView.setPlaceholder("value");
        ((HTMLInputElement)Mockito.verify((Object)this.input)).setAttribute("placeholder", "value");
    }

    @Test
    public void testSetInputType() {
        String attribute = "type";
        String value = "number";
        this.selectorView.setInputType("number");
        ((HTMLInputElement)Mockito.verify((Object)this.input)).setAttribute("type", "number");
    }

    @Test
    public void testSelect() {
        this.selectorView.select();
        ((HTMLInputElement)Mockito.verify((Object)this.input)).select();
    }

    @Test
    public void testOnGenericInputBlur() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        this.selectorView.setOnInputBlurCallback(this.blurEventConsumer);
        this.selectorView.onGenericInputBlur(blurEvent);
        ((Consumer)Mockito.verify(this.blurEventConsumer)).accept(blurEvent);
    }

    @Test
    public void testSetOnInputChangeCallbackWithKeyUpEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.selectorView.setOnInputChangeCallback(this.eventConsumer);
        this.input.onkeyup.onInvoke(event);
        ((Consumer)Mockito.verify(this.eventConsumer)).accept(event);
    }

    @Test
    public void testSetOnInputChangeCallbackWithChangeEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.selectorView.setOnInputChangeCallback(this.eventConsumer);
        this.input.onchange.onInvoke(event);
        ((Consumer)Mockito.verify(this.eventConsumer)).accept(event);
    }
}

