/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValueConverter;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DayTimeSelectorTest {
    @Mock
    private DayTimeSelector.View view;
    @Mock
    private DayTimeValueConverter converter;
    private DayTimeSelector dayTimeSelector;

    @Before
    public void setup() {
        this.dayTimeSelector = (DayTimeSelector)Mockito.spy((Object)new DayTimeSelector(this.view, this.converter));
    }

    @Test
    public void testGetValue() {
        DayTimeValue value = (DayTimeValue)Mockito.mock(DayTimeValue.class);
        String expected = "dmnString";
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)value);
        Mockito.when((Object)this.converter.toDMNString(value)).thenReturn((Object)"dmnString");
        Mockito.when((Object)value.isEmpty()).thenReturn((Object)false);
        String actual = this.dayTimeSelector.getValue();
        Assert.assertEquals((Object)"dmnString", (Object)actual);
    }

    @Test
    public void testGetValueWhenValueIsEmpty() {
        DayTimeValue value = (DayTimeValue)Mockito.mock(DayTimeValue.class);
        String expected = "";
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)value);
        Mockito.when((Object)value.isEmpty()).thenReturn((Object)true);
        String actual = this.dayTimeSelector.getValue();
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void testSetValue() {
        DayTimeValue value = (DayTimeValue)Mockito.mock(DayTimeValue.class);
        String dmnString = "dmnString";
        Mockito.when((Object)this.converter.fromDMNString("dmnString")).thenReturn((Object)value);
        this.dayTimeSelector.setValue("dmnString");
        ((DayTimeSelector.View)Mockito.verify((Object)this.view)).setValue(value);
    }

    @Test
    public void testSetPlaceholder() {
        this.dayTimeSelector.setPlaceholder("");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view, this.converter});
    }

    @Test
    public void testGetElement() {
        HTMLElement expected = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expected);
        Element actual = this.dayTimeSelector.getElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetOnInputChangeCallback() {
        Consumer<Event> onValueChanged = e -> {};
        this.dayTimeSelector.setOnInputChangeCallback(onValueChanged);
        ((DayTimeSelector.View)Mockito.verify((Object)this.view)).setOnValueChanged(onValueChanged);
    }

    @Test
    public void testSetOnInputBlurCallback() {
        Consumer<BlurEvent> onValueInputBlur = e -> {};
        this.dayTimeSelector.setOnInputBlurCallback(onValueInputBlur);
        ((DayTimeSelector.View)Mockito.verify((Object)this.view)).setOnValueInputBlur(onValueInputBlur);
    }

    @Test
    public void testSelect() {
        this.dayTimeSelector.select();
        ((DayTimeSelector.View)Mockito.verify((Object)this.view)).select();
    }

    @Test
    public void testToDisplay() {
        String rawValue = "rawValue";
        String expected = "display value";
        Mockito.when((Object)this.converter.toDisplayValue("rawValue")).thenReturn((Object)"display value");
        String actual = this.dayTimeSelector.toDisplay("rawValue");
        Assert.assertEquals((Object)"display value", (Object)actual);
    }
}

