/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item;

import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueComponentSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item.DataTypeConstraintEnumerationItemView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConstraintEnumerationItemViewTest {
    @Mock
    private HTMLElement valueText;
    @Mock
    private HTMLDivElement valueInput;
    @Mock
    private HTMLAnchorElement saveAnchor;
    @Mock
    private HTMLAnchorElement clearFieldAnchor;
    @Mock
    private HTMLAnchorElement removeAnchor;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataTypeConstraintEnumerationItem presenter;
    @Mock
    private TypedValueComponentSelector componentSelector;
    @Mock
    private TypedValueSelector typedValueSelector;
    private DataTypeConstraintEnumerationItemView view;

    @Before
    public void setup() {
        this.view = (DataTypeConstraintEnumerationItemView)Mockito.spy((Object)new DataTypeConstraintEnumerationItemView(this.valueText, this.valueInput, this.saveAnchor, this.removeAnchor, this.clearFieldAnchor, this.translationService, this.componentSelector));
        this.view.init(this.presenter);
        this.clearFieldAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.removeAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.componentSelector.makeSelectorForType((String)Matchers.any())).thenReturn((Object)this.typedValueSelector);
        this.view.setComponentSelector("someType");
    }

    @Test
    public void testShowValueText() {
        this.valueText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.valueInput.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showValueText();
        ((DOMTokenList)Mockito.verify((Object)this.valueText.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.valueInput.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowValueInput() {
        this.valueText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.valueInput.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showValueInput();
        ((DOMTokenList)Mockito.verify((Object)this.valueInput.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.valueText.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testFocusValueInput() {
        this.view.focusValueInput();
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).select();
    }

    @Test
    public void testShowSaveButton() {
        this.saveAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showSaveButton();
        ((DOMTokenList)Mockito.verify((Object)this.saveAnchor.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideSaveButton() {
        this.saveAnchor.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideSaveButton();
        ((DOMTokenList)Mockito.verify((Object)this.saveAnchor.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testEnableHighlight() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.enableHighlight();
        ((DOMTokenList)Mockito.verify((Object)element.classList)).add(new String[]{"highlighted"});
    }

    @Test
    public void testDisableHighlight() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.disableHighlight();
        ((DOMTokenList)Mockito.verify((Object)element.classList)).remove(new String[]{"highlighted"});
    }

    @Test
    public void testOnValueTextClick() {
        this.view.onValueTextClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).enableEditMode();
    }

    @Test
    public void testOnSaveAnchorClick() {
        String value = "value";
        this.typedValueSelector.setValue("value");
        Mockito.when((Object)this.typedValueSelector.getValue()).thenReturn((Object)"value");
        this.view.onSaveAnchorClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).save("value");
    }

    @Test
    public void testOnRemoveAnchorClick() {
        this.view.onRemoveAnchorClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).remove();
    }

    @Test
    public void testOnValueInputBlurWhenRelatedTargetIsNotSaveButton() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        EventTarget mock = (EventTarget)Mockito.mock(EventTarget.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)mock).when((Object)this.view)).getEventTarget(blurEvent);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.saveAnchor).when((Object)this.view)).getSaveAnchorTarget();
        this.view.onValueInputBlur(blurEvent);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).discardEditMode();
    }

    @Test
    public void testOnValueInputBlurWhenRelatedTargetNotSaveButton() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.saveAnchor).when((Object)this.view)).getEventTarget(blurEvent);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.saveAnchor).when((Object)this.view)).getSaveAnchorTarget();
        this.view.onValueInputBlur(blurEvent);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).discardEditMode();
    }

    @Test
    public void testOnValueInputBlurWhenRelatedTargetIsNotClearButton() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        EventTarget mock = (EventTarget)Mockito.mock(EventTarget.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)mock).when((Object)this.view)).getEventTarget(blurEvent);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.clearFieldAnchor).when((Object)this.view)).getClearAnchorTarget();
        this.view.onValueInputBlur(blurEvent);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).discardEditMode();
    }

    @Test
    public void testOnValueInputBlurWhenRelatedTargetIsClearButton() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.clearFieldAnchor).when((Object)this.view)).getEventTarget(blurEvent);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)this.clearFieldAnchor).when((Object)this.view)).getClearAnchorTarget();
        this.view.onValueInputBlur(blurEvent);
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).discardEditMode();
    }

    @Test
    public void testGetEventTarget() {
        BlurEvent blurEvent = (BlurEvent)Mockito.mock(BlurEvent.class);
        NativeEvent nativeEvent = (NativeEvent)Mockito.mock(NativeEvent.class);
        EventTarget expectedTarget = (EventTarget)Mockito.mock(EventTarget.class);
        Mockito.when((Object)blurEvent.getNativeEvent()).thenReturn((Object)nativeEvent);
        Mockito.when((Object)nativeEvent.getRelatedEventTarget()).thenReturn((Object)expectedTarget);
        Object actualTarget = this.view.getEventTarget(blurEvent);
        Assert.assertEquals((Object)expectedTarget, (Object)actualTarget);
    }

    @Test
    public void testSetValue() {
        String inputValue = "123";
        String expected = "display:123";
        Mockito.when((Object)this.typedValueSelector.toDisplay("123")).thenReturn((Object)"display:123");
        this.valueText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.setValue("123");
        String actualContent = this.valueText.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.valueText.classList)).remove(new String[]{"none"});
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).toDisplay("123");
        Assert.assertEquals((Object)"display:123", (Object)actualContent);
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).setValue("123");
    }

    @Test
    public void testSetValueWhenValueIsNULL() {
        String expectedValue = "- None -";
        Mockito.when((Object)this.translationService.format("DataTypeConstraintEnumerationItemView.None", new Object[0])).thenReturn((Object)"- None -");
        this.valueText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.setValue("null");
        String actualContent = this.valueText.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.valueText.classList)).add(new String[]{"none"});
        Assert.assertEquals((Object)"- None -", (Object)actualContent);
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).setValue("");
    }

    @Test
    public void testSetPlaceholder() {
        String value = "value";
        this.view.setPlaceholder("value");
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).setPlaceholder("value");
    }

    @Test
    public void testShowClearButton() {
        this.view.showClearButton();
        ((DOMTokenList)Mockito.verify((Object)this.clearFieldAnchor.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void hideClearButton() {
        this.view.hideClearButton();
        ((DOMTokenList)Mockito.verify((Object)this.clearFieldAnchor.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void hideDeleteButton() {
        this.view.hideDeleteButton();
        ((DOMTokenList)Mockito.verify((Object)this.removeAnchor.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void showDeleteButton() {
        this.view.showDeleteButton();
        ((DOMTokenList)Mockito.verify((Object)this.removeAnchor.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testOnClearFieldAnchorClick() {
        this.view.onClearFieldAnchorClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeConstraintEnumerationItem)Mockito.verify((Object)this.presenter)).setValue("");
        ((TypedValueSelector)Mockito.verify((Object)this.typedValueSelector)).select();
    }

    @Test
    public void testSetComponentSelector() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        String type = "type";
        ((TypedValueSelector)Mockito.doReturn((Object)element).when((Object)this.typedValueSelector)).getElement();
        this.view.setComponentSelector("type");
        ((TypedValueComponentSelector)Mockito.verify((Object)this.componentSelector)).makeSelectorForType("type");
        ((HTMLDivElement)Mockito.verify((Object)this.valueInput)).appendChild((Node)element);
    }

    @Test
    public void testGetOrder() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        boolean expected = true;
        Mockito.when((Object)element.getAttribute("data-position")).thenReturn((Object)String.valueOf(1));
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        int actual = this.view.getOrder();
        Assert.assertEquals((long)1L, (long)actual);
    }

    @Test
    public void testGetOrderEmptyString() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        boolean expected = false;
        Mockito.when((Object)element.getAttribute("data-position")).thenReturn((Object)"");
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        int actual = this.view.getOrder();
        Assert.assertEquals((long)0L, (long)actual);
    }

    @Test
    public void testSetOrder() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DataTypeConstraintEnumerationItemView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        this.view.setOrder(1);
        ((HTMLElement)Mockito.verify((Object)element)).setAttribute("data-position", 1.0);
    }
}

