/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.client.editors.documentation.DocumentationLinksWidget;
import org.kie.workbench.common.dmn.client.property.dmn.DocumentationLinksFieldDefinition;
import org.kie.workbench.common.dmn.client.property.dmn.DocumentationLinksFieldRenderer;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.impl.def.DefaultFormGroup;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DocumentationLinksFieldRendererTest {
    @Mock
    private DocumentationLinksWidget widget;
    private DocumentationLinksFieldRenderer renderer;
    @Mock
    private FormRenderingContext renderingContext;
    @Mock
    private DRGElement model;
    @Mock
    private DocumentationLinksFieldDefinition field;

    @Before
    public void setup() {
        this.renderer = (DocumentationLinksFieldRenderer)Mockito.spy((Object)new DocumentationLinksFieldRenderer(this.widget));
    }

    @Test
    public void testInit() {
        Mockito.when((Object)this.renderingContext.getModel()).thenReturn((Object)this.model);
        ((DocumentationLinksFieldRenderer)Mockito.doNothing().when((Object)this.renderer)).superInit(this.renderingContext, this.field);
        this.renderer.init(this.renderingContext, this.field);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setDMNModel(this.model);
        ((DocumentationLinksFieldRenderer)Mockito.verify((Object)this.renderer)).superInit(this.renderingContext, this.field);
    }

    @Test
    public void testGetFormGroupEditMode() {
        this.testGetFormGroup(RenderMode.EDIT_MODE, true);
    }

    @Test
    public void testGetFormGroupPrettyMode() {
        this.testGetFormGroup(RenderMode.PRETTY_MODE, false);
    }

    @Test
    public void testGetFormGroupReadOnlyMode() {
        this.testGetFormGroup(RenderMode.READ_ONLY_MODE, false);
    }

    public void testGetFormGroup(RenderMode renderMode, boolean enableWidget) {
        this.renderer.init(this.renderingContext, this.field);
        DefaultFormGroup defaultFormGroup = (DefaultFormGroup)Mockito.mock(DefaultFormGroup.class);
        ((DocumentationLinksFieldRenderer)Mockito.doReturn((Object)defaultFormGroup).when((Object)this.renderer)).getFormGroupInstance();
        this.renderer.getFormGroup(renderMode);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setEnabled(enableWidget);
        ((DefaultFormGroup)Mockito.verify((Object)defaultFormGroup)).render((Widget)this.widget, (FieldDefinition)this.field);
    }

    @Test
    public void testSetReadOnly() {
        this.renderer.setReadOnly(true);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setEnabled(false);
        this.renderer.setReadOnly(false);
        ((DocumentationLinksWidget)Mockito.verify((Object)this.widget)).setEnabled(true);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)DocumentationLinksFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.renderer.getName());
    }

    @Test
    public void testGetSupportedCode() {
        Assert.assertEquals((Object)DocumentationLinksFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.renderer.getSupportedCode());
    }
}

