/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.dnd;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.widgets.dnd.DelegatingGridWidgetDndMouseMoveHandler;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DelegatingGridWidgetDndMouseMoveHandlerTest {
    @Mock
    private GridLayer gridLayer;
    @Mock
    private GridWidgetDnDHandlersState state;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private Viewport viewport;
    @Mock
    private DivElement element;
    @Mock
    private Style style;
    private DelegatingGridWidgetDndMouseMoveHandler handler;

    @Before
    public void setup() {
        this.handler = new DelegatingGridWidgetDndMouseMoveHandler(this.gridLayer, this.state);
    }

    @Test
    public void testDelegationToGridWidget() {
        GridWidget view = (GridWidget)Mockito.mock(GridWidget.class);
        ((GridWidget)Mockito.doReturn((Object)this.rendererHelper).when((Object)view)).getRendererHelper();
        this.handler.findMovableRows(view, 0.0, 0.0);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testDelegationToHasRowDragRestrictionsWhenPermitted() {
        ContextGrid view = (ContextGrid)Mockito.mock(ContextGrid.class);
        ((ContextGrid)Mockito.doReturn((Object)this.rendererHelper).when((Object)view)).getRendererHelper();
        ((ContextGrid)Mockito.doReturn((Object)true).when((Object)view)).isRowDragPermitted((GridWidgetDnDHandlersState)Matchers.eq((Object)this.state));
        this.handler.findMovableRows((GridWidget)view, 0.0, 0.0);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testDelegationToHasRowDragRestrictionsWhenNotPermitted() {
        ContextGrid view = (ContextGrid)Mockito.mock(ContextGrid.class);
        ((ContextGrid)Mockito.doReturn((Object)this.rendererHelper).when((Object)view)).getRendererHelper();
        ((ContextGrid)Mockito.doReturn((Object)false).when((Object)view)).isRowDragPermitted((GridWidgetDnDHandlersState)Matchers.eq((Object)this.state));
        ((GridWidgetDnDHandlersState)Mockito.doReturn((Object)Style.Cursor.DEFAULT).when((Object)this.state)).getCursor();
        ((GridLayer)Mockito.doReturn((Object)this.viewport).when((Object)this.gridLayer)).getViewport();
        ((Viewport)Mockito.doReturn((Object)this.element).when((Object)this.viewport)).getElement();
        ((DivElement)Mockito.doReturn((Object)this.style).when((Object)this.element)).getStyle();
        this.handler.findMovableRows((GridWidget)view, 0.0, 0.0);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state)).reset();
        ((Style)Mockito.verify((Object)this.style)).setCursor((Style.Cursor)Matchers.eq((Object)Style.Cursor.DEFAULT));
    }
}

