/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;

public abstract class BaseDOMElementSingletonColumnTest<F extends BaseSingletonDOMElementFactory, D extends BaseDOMElement & Focusable, W extends Widget, C extends BaseGridColumn, G extends BaseExpressionGrid> {
    private static final String DEFAULT_VALUE = "";
    @Mock
    protected GridColumn.HeaderMetaData headerMetaData;
    @Mock
    protected GridBodyCellRenderContext context;
    @Captor
    protected ArgumentCaptor<Consumer<D>> domElementOnCreationCallbackCaptor;
    @Captor
    protected ArgumentCaptor<Consumer<D>> domElementOnDisplayCallbackCaptor;
    protected GridData model;
    protected F factory;
    protected D domElement;
    protected W widget;
    protected G gridWidget;
    protected C column;

    @Before
    public void setup() {
        this.model = new DMNGridData();
        this.factory = this.getFactory();
        this.domElement = this.getDomElement();
        this.widget = this.getWidget();
        this.gridWidget = this.getGridWidget();
        this.column = this.getColumn();
        Mockito.when((Object)this.domElement.getWidget()).thenReturn(this.widget);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.model);
    }

    protected abstract F getFactory();

    protected abstract D getDomElement();

    protected abstract W getWidget();

    protected abstract G getGridWidget();

    protected abstract C getColumn();

    @Test
    public void checkEdit() {
        String value = "value";
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"value"));
        this.column.edit((GridCell)cell, this.context, result -> {});
        this.assertCellEdit("value");
    }

    @Test
    public void checkEditNullCell() {
        this.column.edit(null, this.context, result -> {});
        this.assertCellEdit(DEFAULT_VALUE);
    }

    @Test
    public void checkEditNullCellValue() {
        BaseGridCell cell = new BaseGridCell(null);
        this.column.edit((GridCell)cell, this.context, result -> {});
        this.assertCellEdit(DEFAULT_VALUE);
    }

    @Test
    public void checkEditNullCellValueValue() {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue(null));
        this.column.edit((GridCell)cell, this.context, result -> {});
        this.assertCellEdit(DEFAULT_VALUE);
    }

    protected void assertCellEdit(String value) {
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).attachDomElement((GridBodyCellRenderContext)Matchers.eq((Object)this.context), (Consumer)this.domElementOnCreationCallbackCaptor.capture(), (Consumer)this.domElementOnDisplayCallbackCaptor.capture());
        Consumer domElementOnCreationCallback = (Consumer)this.domElementOnCreationCallbackCaptor.getValue();
        domElementOnCreationCallback.accept(this.domElement);
        ((TakesValue)((BaseDOMElement)Mockito.verify(this.domElement))).setValue(Matchers.eq((Object)value));
        Consumer domElementOnDisplayCallback = (Consumer)this.domElementOnDisplayCallbackCaptor.getValue();
        domElementOnDisplayCallback.accept(this.domElement);
        ((Focusable)((BaseDOMElement)Mockito.verify(this.domElement))).setFocus(Matchers.eq((boolean)true));
    }

    @Test
    public void checkFlushFactory() {
        ((HasSingletonDOMElementResource)this.column).flush();
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).flush();
    }

    @Test
    public void checkDestroyFactoryResources() {
        ((HasDOMElementResources)this.column).destroyResources();
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).destroyResources();
    }

    @Test
    public void testDestroyHeaderMetadataAdditionalDomElements() {
        EditableHeaderMetaData editableHeaderMetaData = (EditableHeaderMetaData)Mockito.mock(EditableHeaderMetaData.class);
        this.column.getHeaderMetaData().add(editableHeaderMetaData);
        ((HasDOMElementResources)this.column).destroyResources();
        ((EditableHeaderMetaData)Mockito.verify((Object)editableHeaderMetaData)).destroyResources();
    }

    @Test
    public void testDestroyExpressionGridAdditionalDomElements() {
        if (this.gridWidget instanceof BaseExpressionGrid) {
            ((HasDOMElementResources)this.column).destroyResources();
            ((BaseExpressionGrid)Mockito.verify(this.gridWidget)).destroyResources();
        }
    }
}

