/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.PopupEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class CellEditorControlsTest {
    private static final Optional<String> EDITOR_TITLE = Optional.of("editor");
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private CellEditorControlsView view;
    @Mock
    private HasCellEditorControls.Editor editor;
    private CellEditorControlsView.Presenter controls;

    @Before
    public void setup() {
        this.controls = new CellEditorControls(this.view);
        this.controls.setGridPanelSupplier(Optional.of(() -> this.gridPanel));
        ((DMNGridPanel)Mockito.doReturn((Object)this.viewport).when((Object)this.gridPanel)).getViewport();
        ((Viewport)Mockito.doReturn((Object)this.transform).when((Object)this.viewport)).getTransform();
    }

    @Test
    public void testShow() {
        ((Transform)Mockito.doReturn((Object)0.5).when((Object)this.transform)).getScaleX();
        ((Transform)Mockito.doReturn((Object)-100.0).when((Object)this.transform)).getTranslateX();
        ((DMNGridPanel)Mockito.doReturn((Object)-50).when((Object)this.gridPanel)).getAbsoluteLeft();
        ((Transform)Mockito.doReturn((Object)0.25).when((Object)this.transform)).getScaleY();
        ((Transform)Mockito.doReturn((Object)-200.0).when((Object)this.transform)).getTranslateY();
        ((DMNGridPanel)Mockito.doReturn((Object)-75).when((Object)this.gridPanel)).getAbsoluteTop();
        this.controls.show(this.editor, EDITOR_TITLE, 10, 20);
        ((CellEditorControlsView)Mockito.verify((Object)this.view)).show((PopupEditorControls)Matchers.eq((Object)this.editor), (Optional)Matchers.eq(EDITOR_TITLE), Matchers.eq((int)-145), Matchers.eq((int)-270));
    }

    @Test
    public void testHide() {
        this.controls.hide();
        ((CellEditorControlsView)Mockito.verify((Object)this.view)).hide();
    }
}

