/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorDividerItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorHeaderItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorTextItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListSelectorViewImplTest {
    @Mock
    private UnorderedList itemsContainer;
    @Mock
    private ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews;
    @Mock
    private ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews;
    @Mock
    private ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews;
    @Mock
    private ListSelectorView.Presenter presenter;
    @Mock
    private ListSelectorTextItemView textItemView;
    @Mock
    private HTMLElement textElement;
    @Mock
    private HasListSelectorControl.ListSelectorTextItem textItem;
    @Mock
    private ListSelectorDividerItemView dividerItemView;
    @Mock
    private HTMLElement dividerElement;
    @Mock
    private HasListSelectorControl.ListSelectorDividerItem dividerItem;
    @Mock
    private ListSelectorHeaderItemView headerItemView;
    @Mock
    private HTMLElement headerElement;
    @Mock
    private HasListSelectorControl.ListSelectorHeaderItem headerItem;
    private ListSelectorViewImpl view;

    @Before
    public void setUp() {
        this.view = new ListSelectorViewImpl(this.itemsContainer, this.listSelectorTextItemViews, this.listSelectorDividerItemViews, this.listSelectorHeaderItemViews);
        this.view.init(this.presenter);
        ((ManagedInstance)Mockito.doReturn((Object)this.textItemView).when(this.listSelectorTextItemViews)).get();
        ((ListSelectorTextItemView)Mockito.doReturn((Object)this.textElement).when((Object)this.textItemView)).getElement();
        ((ManagedInstance)Mockito.doReturn((Object)this.dividerItemView).when(this.listSelectorDividerItemViews)).get();
        ((ListSelectorDividerItemView)Mockito.doReturn((Object)this.dividerElement).when((Object)this.dividerItemView)).getElement();
        ((ManagedInstance)Mockito.doReturn((Object)this.headerItemView).when(this.listSelectorHeaderItemViews)).get();
        ((ListSelectorHeaderItemView)Mockito.doReturn((Object)this.headerElement).when((Object)this.headerItemView)).getElement();
    }

    @Test
    public void testSetItems() {
        boolean textItemEnabled = true;
        String textItemText = "Insert rule above";
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)true).when((Object)this.textItem)).isEnabled();
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)"Insert rule above").when((Object)this.textItem)).getText();
        String headerItemText = "Header";
        ((HasListSelectorControl.ListSelectorHeaderItem)Mockito.doReturn((Object)"Header").when((Object)this.headerItem)).getText();
        this.view.setItems(Arrays.asList(this.textItem, this.dividerItem, this.headerItem));
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.textElement);
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.dividerElement);
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer)).appendChild((Node)this.headerElement);
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).setEnabled(Matchers.eq((boolean)true));
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).setText((String)Matchers.eq((Object)"Insert rule above"));
        ((ListSelectorHeaderItemView)Mockito.verify((Object)this.headerItemView)).setText((String)Matchers.eq((Object)"Header"));
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((ListSelectorTextItemView)Mockito.verify((Object)this.textItemView)).addClickHandler((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((ListSelectorView.Presenter)Mockito.verify((Object)this.presenter)).onItemSelected((HasListSelectorControl.ListSelectorItem)Matchers.eq((Object)this.textItem));
        Mockito.reset((Object[])new ListSelectorView.Presenter[]{this.presenter});
        ((HasListSelectorControl.ListSelectorTextItem)Mockito.doReturn((Object)false).when((Object)this.textItem)).isEnabled();
        ((Command)commandCaptor.getValue()).execute();
        ((ListSelectorView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).onItemSelected((HasListSelectorControl.ListSelectorItem)Matchers.any(HasListSelectorControl.ListSelectorTextItem.class));
    }

    @Test
    public void testSetItemsUnknownImplementation() {
        this.view.setItems(Arrays.asList((HasListSelectorControl.ListSelectorItem)Mockito.mock(HasListSelectorControl.ListSelectorItem.class)));
        ((UnorderedList)Mockito.verify((Object)this.itemsContainer, (VerificationMode)Mockito.never())).appendChild((Node)Matchers.any());
    }
}

