/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.model.LiteralExpressionGridRow;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class LiteralExpressionGridRowTest {
    private static final double TEXT_LINE_HEIGHT = 10.0;

    @Test
    public void testEmptyRow() throws Exception {
        LiteralExpressionGridRow row = new LiteralExpressionGridRow(10.0);
        Assertions.assertThat((double)row.getHeight()).isEqualTo(48.0);
    }

    @Test
    public void testGetHeightWithEmptyExpressionText() {
        this.assertRowHeight("", 48.0);
    }

    private void assertRowHeight(final String value, double expectedHeight) {
        GridRow row = (GridRow)Mockito.spy((Object)new LiteralExpressionGridRow(10.0));
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                this.put(0, new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)value)));
            }
        };
        ((GridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(expectedHeight);
    }

    @Test
    public void testGetHeightWithMultiLineExpressionText() {
        this.assertRowHeight("1\n2\n3\n4", 55.0);
    }

    @Test
    public void testGetHeightWithEmptyLinesExpressionText() {
        this.assertRowHeight("1\n2\n\n\n3\n4", 75.0);
    }

    @Test
    public void testGetHeightWithDifferentEndOfLinesExpressionText() {
        this.assertRowHeight("1\n2\r\n \n3\n4 \r\n", 75.0);
    }

    @Test
    public void testGetHeightEndingWithEmptyLineExpressionText() {
        this.assertRowHeight("1\n2\r\n3\n", 55.0);
    }
}

