/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.included.components;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponentsItem;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Dependent
public class DecisionComponentFilter {
    private String drgElement;
    private String term;

    void setDrgElement(String drgElement) {
        this.drgElement = drgElement;
    }

    void setTerm(String term) {
        this.term = term;
    }

    Optional<String> getDrgElement() {
        return this.getOptionalString(this.drgElement);
    }

    Optional<String> getTerm() {
        return this.getOptionalString(this.term);
    }

    Stream<DecisionComponentsItem> query(Stream<DecisionComponentsItem> stream) {
        return stream.filter(this.byDrgElement()).filter(this.byTerm());
    }

    private Optional<String> getOptionalString(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private Predicate<DecisionComponentsItem> byTerm() {
        return item -> this.getTerm().map(term -> this.containsIgnoringCase(item.getDecisionComponent().getName(), (String)term)).orElse(true);
    }

    private Predicate<DecisionComponentsItem> byDrgElement() {
        return item -> this.getDrgElement().map(filterDrgElement -> Objects.equals(this.getDrgElementClass((DecisionComponentsItem)item), filterDrgElement)).orElse(true);
    }

    private String getDrgElementClass(DecisionComponentsItem item) {
        return item.getDecisionComponent().getDrgElement().getClass().getSimpleName();
    }

    private boolean containsIgnoringCase(String container, String contained) {
        return container.toUpperCase().contains(contained.toUpperCase());
    }
}

