/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DecisionNavigatorTreePresenter {
    private final View view;
    private final Map<String, DecisionNavigatorItem> indexedItems = new HashMap<String, DecisionNavigatorItem>();
    private String activeParentUUID;

    @Inject
    public DecisionNavigatorTreePresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setupItems(List<DecisionNavigatorItem> items) {
        this.setup(items);
    }

    public void addOrUpdateItem(DecisionNavigatorItem item) {
        if (!this.isChanged(item) || !this.hasParent(item)) {
            return;
        }
        if (this.view.hasItem(item)) {
            this.updateItem(item);
        } else {
            this.addItem(item);
        }
    }

    public void updateItem(DecisionNavigatorItem item) {
        this.index(item);
        this.view.update(item, this.nextItem(item));
    }

    public void addItem(DecisionNavigatorItem item) {
        this.index(item);
        this.view.addItem(item, this.nextItem(item));
    }

    public void remove(DecisionNavigatorItem item) {
        this.unIndex(item);
        this.view.remove(item);
    }

    public void removeAllItems() {
        this.view.clean();
        this.getIndexedItems().clear();
    }

    public DecisionNavigatorItem getActiveParent() {
        return this.getIndexedItems().get(this.activeParentUUID);
    }

    public void setActiveParentUUID(String activeParentUUID) {
        this.activeParentUUID = activeParentUUID;
    }

    public void selectItem(String uuid) {
        this.view.select(uuid);
    }

    public void deselectItem() {
        this.view.deselect();
    }

    DecisionNavigatorItem nextItem(DecisionNavigatorItem item) {
        DecisionNavigatorItem parent = this.getIndexedItems().get(item.getParentUUID());
        TreeSet<DecisionNavigatorItem> children = parent.getChildren();
        return children.higher(item);
    }

    void index(Collection<DecisionNavigatorItem> items) {
        items.forEach(this::index);
    }

    void index(DecisionNavigatorItem item) {
        this.parent(item).ifPresent(parent -> parent.addChild(item));
        this.getIndexedItems().put(item.getUUID(), item);
        this.index(item.getChildren());
    }

    void unIndex(DecisionNavigatorItem item) {
        this.parent(item).ifPresent(parent -> parent.removeChild(item));
        this.getIndexedItems().remove(item.getUUID());
    }

    boolean isChanged(DecisionNavigatorItem item) {
        DecisionNavigatorItem currentItem = this.getIndexedItems().get(item.getUUID());
        return !item.equals(currentItem);
    }

    boolean hasParent(DecisionNavigatorItem item) {
        return this.parent(item).isPresent();
    }

    Optional<DecisionNavigatorItem> parent(DecisionNavigatorItem item) {
        DecisionNavigatorItem parent = this.getIndexedItems().get(item.getParentUUID());
        return Optional.ofNullable(parent);
    }

    DecisionNavigatorItem findRoot() {
        return this.getIndexedItems().values().stream().filter(i -> i.getType() == DecisionNavigatorItem.Type.ROOT).findFirst().orElseThrow(RuntimeException::new);
    }

    Map<String, DecisionNavigatorItem> getIndexedItems() {
        return this.indexedItems;
    }

    private void setup(List<DecisionNavigatorItem> items) {
        this.index(items);
        this.view.clean();
        this.view.setup(items);
    }

    public static interface View
    extends UberElemental<DecisionNavigatorTreePresenter> {
        public void clean();

        public void setup(List<DecisionNavigatorItem> var1);

        public void addItem(DecisionNavigatorItem var1, DecisionNavigatorItem var2);

        public void update(DecisionNavigatorItem var1, DecisionNavigatorItem var2);

        public boolean hasItem(DecisionNavigatorItem var1);

        public void remove(DecisionNavigatorItem var1);

        public void select(String var1);

        public void deselect();
    }
}

