/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.links;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.client.editors.documentation.links.NameAndUrlPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;

@Templated
@ApplicationScoped
public class NameAndUrlPopoverViewImpl
extends AbstractPopoverViewImpl
implements NameAndUrlPopoverView {
    private NameAndUrlPopoverView.Presenter presenter;
    @DataField(value="urlLabel")
    private HTMLElement urlLabel;
    @DataField(value="nameLabel")
    private HTMLElement attachmentName;
    @DataField(value="attachmentTip")
    private HTMLElement attachmentTip;
    @DataField(value="cancelButton")
    private HTMLButtonElement cancelButton;
    @DataField(value="okButton")
    private HTMLButtonElement okButton;
    @DataField(value="urlInput")
    private HTMLInputElement urlInput;
    @DataField(value="attachmentNameInput")
    private HTMLInputElement attachmentNameInput;
    private Consumer<DMNExternalLink> onExternalLinkCreated;
    private TranslationService translationService;

    public NameAndUrlPopoverViewImpl() {
    }

    @Inject
    public NameAndUrlPopoverViewImpl(Div popoverElement, Div popoverContentElement, JQueryProducer.JQuery<Popover> jQueryPopover, TranslationService translationService, HTMLButtonElement cancelButton, HTMLButtonElement okButton, HTMLInputElement urlInput, HTMLInputElement attachmentNameInput, @Named(value="span") HTMLElement urlLabel, @Named(value="span") HTMLElement attachmentName, @Named(value="span") HTMLElement attachmentTip) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.urlLabel = urlLabel;
        this.attachmentName = attachmentName;
        this.cancelButton = cancelButton;
        this.okButton = okButton;
        this.urlInput = urlInput;
        this.attachmentNameInput = attachmentNameInput;
        this.translationService = translationService;
        this.attachmentTip = attachmentTip;
    }

    @PostConstruct
    public void init() {
        this.okButton.disabled = true;
        this.urlLabel.textContent = this.translationService.getTranslation("DMNDocumentationI18n.URL");
        this.attachmentName.textContent = this.translationService.getTranslation("DMNDocumentationI18n.Name");
        this.urlInput.placeholder = this.translationService.getTranslation("DMNDocumentationI18n.URLPlaceholder");
        this.attachmentNameInput.placeholder = this.translationService.getTranslation("DMNDocumentationI18n.NamePlaceholder");
        this.okButton.textContent = this.translationService.getTranslation("DMNDocumentationI18n.Ok");
        this.cancelButton.textContent = this.translationService.getTranslation("DMNDocumentationI18n.Cancel");
        this.attachmentTip.textContent = this.translationService.getTranslation("DMNDocumentationI18n.AttachmentTip");
        this.setOnChangedHandlers();
    }

    private void setOnChangedHandlers() {
        this.urlInput.onkeyup = this.getOnKeyUpHandler();
        this.attachmentNameInput.onkeyup = this.getOnKeyUpHandler();
    }

    Element.OnkeyupCallbackFn getOnKeyUpHandler() {
        return e -> {
            this.okButton.disabled = StringUtils.isEmpty((String)this.urlInput.value) || StringUtils.isEmpty((String)this.attachmentNameInput.value);
            return true;
        };
    }

    @EventHandler(value={"okButton"})
    public void onClickOkButton(ClickEvent clickEvent) {
        Consumer<DMNExternalLink> consumer = this.getOnExternalLinkCreated();
        if (!Objects.isNull(consumer)) {
            String description = this.attachmentNameInput.value;
            String url = this.urlInput.value;
            DMNExternalLink externalLink = new DMNExternalLink(url, description);
            consumer.accept(externalLink);
        }
        this.hide();
    }

    @EventHandler(value={"cancelButton"})
    public void onClickCancelButton(ClickEvent clickEvent) {
        this.hide();
    }

    public void init(NameAndUrlPopoverView.Presenter presenter) {
        this.presenter = presenter;
    }

    public Consumer<DMNExternalLink> getOnExternalLinkCreated() {
        return this.onExternalLinkCreated;
    }

    @Override
    public void setOnExternalLinkCreated(Consumer<DMNExternalLink> onExternalLinkCreated) {
        this.onExternalLinkCreated = onExternalLinkCreated;
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.clear();
        this.superShow(editorTitle);
    }

    void superShow(Optional<String> editorTitle) {
        super.show(editorTitle);
    }

    void clear() {
        this.attachmentNameInput.value = "";
        this.urlInput.value = "";
    }
}

