/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.client.decision.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class PMMLDocumentMetadataProvider {
    private DMNGraphUtils graphUtils;
    private DMNClientServicesProxy clientServicesProxy;
    private SessionManager sessionManager;
    private Map<String, PMMLDocumentMetadata> pmmlDocuments = new HashMap<String, PMMLDocumentMetadata>();

    public PMMLDocumentMetadataProvider() {
    }

    @Inject
    public PMMLDocumentMetadataProvider(DMNGraphUtils graphUtils, DMNClientServicesProxy clientServicesProxy, SessionManager sessionManager) {
        this.graphUtils = graphUtils;
        this.clientServicesProxy = clientServicesProxy;
        this.sessionManager = sessionManager;
    }

    @PostConstruct
    public void loadPMMLIncludedDocuments() {
        this.pmmlDocuments.clear();
        this.clientServicesProxy.loadPMMLDocumentsFromImports(this.getDMNModelPath(), this.getPMMLIncludedModels(), new ServiceCallback<List<PMMLDocumentMetadata>>(){

            public void onSuccess(List<PMMLDocumentMetadata> documents) {
                documents.forEach(document -> PMMLDocumentMetadataProvider.this.pmmlDocuments.put(document.getName(), document));
            }

            public void onError(ClientRuntimeError error) {
                PMMLDocumentMetadataProvider.this.clientServicesProxy.logWarning(error);
            }
        });
    }

    public void onRefreshDecisionComponents(@Observes RefreshDecisionComponents events) {
        this.loadPMMLIncludedDocuments();
    }

    private Diagram getDiagram() {
        return this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram();
    }

    private Path getDMNModelPath() {
        Diagram diagram = this.getDiagram();
        return diagram.getMetadata().getPath();
    }

    private List<PMMLIncludedModel> getPMMLIncludedModels() {
        Diagram diagram = this.getDiagram();
        return this.graphUtils.getDefinitions(diagram).getImport().stream().filter(anImport -> Objects.equals(DMNImportTypes.PMML, DMNImportTypes.determineImportType((String)anImport.getImportType()))).map(this::asPMMLIncludedModel).collect(Collectors.toList());
    }

    private PMMLIncludedModel asPMMLIncludedModel(Import anImport) {
        String modelName = anImport.getName().getValue();
        String importType = anImport.getImportType();
        String path = anImport.getLocationURI().getValue();
        return new PMMLIncludedModel(modelName, "", path, importType, Integer.valueOf(0));
    }

    public List<String> getPMMLDocumentNames() {
        ArrayList<String> pmmlDocumentNames = new ArrayList<String>(this.pmmlDocuments.keySet());
        pmmlDocumentNames.sort(Comparator.naturalOrder());
        return pmmlDocumentNames;
    }

    public List<String> getPMMLDocumentModels(String pmmlDocumentName) {
        ArrayList<String> pmmlDocumentModelNames = new ArrayList<String>();
        if (this.pmmlDocuments.containsKey(pmmlDocumentName)) {
            PMMLDocumentMetadata document = this.pmmlDocuments.get(pmmlDocumentName);
            document.getModels().forEach(pmmlDocumentModel -> pmmlDocumentModelNames.add(pmmlDocumentModel.getName()));
            pmmlDocumentModelNames.sort(Comparator.naturalOrder());
        }
        return pmmlDocumentModelNames;
    }

    public List<String> getPMMLDocumentModelParameterNames(String pmmlDocumentName, String pmmlDocumentModelName) {
        ArrayList<String> pmmlDocumentModelParameterNames = new ArrayList<String>();
        if (this.pmmlDocuments.containsKey(pmmlDocumentName)) {
            PMMLDocumentMetadata document = this.pmmlDocuments.get(pmmlDocumentName);
            document.getModels().stream().filter(model -> Objects.equals(pmmlDocumentModelName, model.getName())).findFirst().map(PMMLModelMetadata::getInputParameters).orElse(Collections.emptySet()).forEach(parameter -> pmmlDocumentModelParameterNames.add(parameter.getName()));
            pmmlDocumentModelParameterNames.sort(Comparator.naturalOrder());
        }
        return pmmlDocumentModelParameterNames;
    }
}

