/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;

@Dependent
public class DataTypeUtils {
    private final DataTypeStore dataTypeStore;
    private final DataTypeManager dataTypeManager;

    @Inject
    public DataTypeUtils(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager) {
        this.dataTypeStore = dataTypeStore;
        this.dataTypeManager = dataTypeManager;
    }

    public List<DataType> defaultDataTypes() {
        return Stream.of(BuiltInType.values()).filter(builtInType -> !builtInType.equals((Object)BuiltInType.UNDEFINED)).map(bit -> this.dataTypeManager.from((BuiltInType)bit).get()).sorted(Comparator.comparing(DataType::getType)).collect(Collectors.toList());
    }

    public List<DataType> customDataTypes() {
        return this.dataTypeStore.getTopLevelDataTypes().stream().sorted(Comparator.comparing(DataType::getName)).collect(Collectors.toList());
    }
}

