/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import elemental2.dom.Text;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryTooltip;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.MenuInitializer;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;

@Dependent
@Templated
public class DataTypeListItemView
implements DataTypeListItem.View {
    public static final String UUID_ATTR = "data-row-uuid";
    public static final String NAME_DATA_FIELD = "name-input";
    static final String PARENT_UUID_ATTR = "data-parent-row-uuid";
    static final String ARROW_BUTTON_SELECTOR = "[data-type-field=\"arrow-button\"]";
    private static final int PIXELS_PER_LEVEL = 35;
    @DataField(value="view")
    private final HTMLDivElement view;
    private final TranslationService translationService;
    private DataTypeListItem presenter;

    @Inject
    public DataTypeListItemView(HTMLDivElement view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setupKebabElement() {
        new MenuInitializer(this.getKebabMenu(), ".dropdown").init();
    }

    public void init(DataTypeListItem presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    void setupRowMetadata(DataType dataType) {
        this.getElement().setAttribute(UUID_ATTR, dataType.getUUID());
        this.getElement().setAttribute(PARENT_UUID_ATTR, dataType.getParentUUID());
        this.setupRowCSSClass(dataType);
    }

    void setupRowCSSClass(DataType dataType) {
        this.setupSubDataTypesCSSClass(dataType);
        this.setupReadOnlyCSSClass(dataType);
    }

    void setupSubDataTypesCSSClass(DataType dataType) {
        String hasSubDataTypesCSSClass = "has-sub-data-types";
        if (dataType.hasSubDataTypes()) {
            this.getElement().classList.add(new String[]{"has-sub-data-types"});
        } else {
            this.getElement().classList.remove(new String[]{"has-sub-data-types"});
        }
    }

    void setupReadOnlyCSSClass(DataType dataType) {
        String readOnlyCSSClass = "read-only";
        if (dataType.isReadOnly()) {
            this.getElement().classList.add(new String[]{"read-only"});
        } else {
            this.getElement().classList.remove(new String[]{"read-only"});
        }
    }

    void setupArrow(DataType dataType) {
        this.toggleArrow(dataType.hasSubDataTypes());
    }

    void setupIndentationLevel() {
        int indentationLevel = this.presenter.getLevel();
        int marginPixels = 35 * indentationLevel;
        String nestingLevelSelector = ".nesting-level";
        NodeList levelElements = this.getElement().querySelectorAll(".nesting-level");
        int i = 0;
        while ((double)i < levelElements.length) {
            Element element = (Element)levelElements.getAt(i);
            String propertyName = "style";
            String propertyValue = "margin-left: " + marginPixels + "px";
            element.setAttribute("style", propertyValue);
            ++i;
        }
    }

    void setupReadOnly(DataType dataType) {
        HiddenHelper.hide((Element)this.getNameInput());
        this.setName(dataType.getName());
    }

    void setupActionButtons() {
        this.showEditButton();
    }

    @Override
    public void toggleArrow(boolean show) {
        if (show) {
            HiddenHelper.show(this.getArrow());
        } else {
            HiddenHelper.hide(this.getArrow());
        }
    }

    @Override
    public void expand() {
        Element parent = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asDownArrow(this.getArrow());
        this.forEachChildElement(parent, (Element child) -> {
            HiddenHelper.show(child);
            return !this.isCollapsed(child.querySelector(ARROW_BUTTON_SELECTOR));
        });
    }

    @Override
    public void collapse() {
        Element parent = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asRightArrow(this.getArrow());
        this.forEachChildElement(parent, HiddenHelper::hide);
    }

    @Override
    public void showEditButton() {
        HiddenHelper.show(this.getEditButton());
        HiddenHelper.hide(this.getSaveButton());
        HiddenHelper.hide(this.getCloseButton());
    }

    @Override
    public void showSaveButton() {
        HiddenHelper.hide(this.getEditButton());
        HiddenHelper.show(this.getSaveButton());
        HiddenHelper.show(this.getCloseButton());
    }

    @Override
    public void enableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asFocusedDataType(rowElement);
        this.forEachChildElement(rowElement, ListItemViewCssHelper::asFocusedDataType);
        this.getNameInput().select();
    }

    @Override
    public void disableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        if (rowElement != null) {
            ListItemViewCssHelper.asNonFocusedDataType(rowElement);
            this.forEachChildElement(rowElement, ListItemViewCssHelper::asNonFocusedDataType);
        }
    }

    @Override
    public boolean isOnFocusMode() {
        return ListItemViewCssHelper.isFocusedDataType(this.getRowElement(this.getDataType()));
    }

    @Override
    public String getName() {
        return this.getNameInput().value;
    }

    @Override
    public void setName(String name) {
        this.getNameText().textContent = name;
        this.getNameInput().value = name;
    }

    @Override
    public void showDataTypeNameInput() {
        HiddenHelper.hide(this.getNameText());
        HiddenHelper.show((Element)this.getNameInput());
        this.showLabels();
    }

    @Override
    public void hideDataTypeNameInput() {
        this.getNameText().textContent = this.getNameInput().value.isEmpty() ? "-" : this.getNameInput().value;
        HiddenHelper.hide((Element)this.getNameInput());
        HiddenHelper.show(this.getNameText());
        this.hideLabels();
    }

    void showLabels() {
        NodeList<Element> labels = this.getLabels();
        int i = 0;
        while ((double)i < labels.length) {
            HiddenHelper.show((Element)labels.getAt(i));
            ++i;
        }
    }

    void hideLabels() {
        NodeList<Element> labels = this.getLabels();
        int i = 0;
        while ((double)i < labels.length) {
            HiddenHelper.hide((Element)labels.getAt(i));
            ++i;
        }
    }

    @Override
    public void setupSelectComponent(DataTypeSelect typeSelect) {
        HTMLElement element = typeSelect.getElement();
        RemoveHelper.removeChildren(this.getType());
        this.getType().appendChild((Node)element);
    }

    @Override
    public void setupConstraintComponent(DataTypeConstraint dataTypeConstraintComponent) {
        RemoveHelper.removeChildren(this.getConstraintContainer());
        this.getConstraintContainer().appendChild((Node)dataTypeConstraintComponent.getElement());
    }

    @Override
    public void setupListComponent(SmallSwitchComponent dataTypeListComponent) {
        RemoveHelper.removeChildren(this.getListContainer());
        this.getListContainer().appendChild((Node)this.listTextNode());
        this.getListContainer().appendChild((Node)dataTypeListComponent.getElement());
    }

    Text listTextNode() {
        return DomGlobal.document.createTextNode(this.list());
    }

    @Override
    public void showListContainer() {
        HiddenHelper.show(this.getListContainer());
    }

    @Override
    public void hideKebabMenu() {
        HiddenHelper.hide(this.getKebabMenu());
    }

    @Override
    public void showKebabMenu() {
        HiddenHelper.show(this.getKebabMenu());
    }

    @Override
    public void hideListContainer() {
        HiddenHelper.hide(this.getListContainer());
    }

    @Override
    public void showListYesLabel() {
        HiddenHelper.show(this.getListYes());
    }

    @Override
    public void hideListYesLabel() {
        HiddenHelper.hide(this.getListYes());
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed(this.getArrow());
    }

    Element getRowElement(DataType dataType) {
        return this.getRowElement(dataType.getUUID());
    }

    boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    private void forEachChildElement(Element parent, Consumer<Element> consumer) {
        this.forEachChildElement(parent, (Element element) -> {
            consumer.accept((Element)element);
            return true;
        });
    }

    private void forEachChildElement(Element parent, Function<Element, Boolean> consumer) {
        NodeList<Element> children = this.getChildren(parent);
        int i = 0;
        while ((double)i < children.length) {
            Element child = (Element)children.getAt(i);
            if (consumer.apply(child).booleanValue()) {
                this.forEachChildElement(child, consumer);
            }
            ++i;
        }
    }

    private Element getRowElement(String uuid) {
        return this.dataTypeListElement().querySelector("[data-row-uuid=\"" + uuid + "\"]");
    }

    private NodeList<Element> getChildren(Element parent) {
        String childrenSelector = "[data-parent-row-uuid=\"" + parent.getAttribute(UUID_ATTR) + "\"]";
        return this.dataTypeListElement().querySelectorAll(childrenSelector);
    }

    HTMLElement dataTypeListElement() {
        return this.presenter.getDataTypeList().getElement();
    }

    DataType getDataType() {
        return this.presenter.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.setupRowMetadata(dataType);
        this.setupArrow(dataType);
        this.setupIndentationLevel();
        this.setupReadOnly(dataType);
        this.setupActionButtons();
        this.setupEventHandlers();
        this.setupShortcutsTooltips();
    }

    void setupShortcutsTooltips() {
        String arrowKeysTooltip = this.translationService.format("DataTypeListItemView.ArrowKeysTooltip", new Object[0]);
        this.setTitleAttribute(this.getEditButton(), "Ctrl + E");
        this.setTitleAttribute(this.getSaveButton(), "Ctrl + S");
        this.setTitleAttribute(this.getInsertNestedField(), "Ctrl + B");
        this.setTitleAttribute(this.getInsertFieldAbove(), "Ctrl + U");
        this.setTitleAttribute(this.getInsertFieldBelow(), "Ctrl + D");
        this.setTitleAttribute(this.getRemoveButton(), "Ctrl + Backspace");
        this.setTitleAttribute(this.getCloseButton(), "Esc");
        this.setTitleAttribute(this.getArrow(), arrowKeysTooltip);
        this.setupTooltips();
    }

    private void setTitleAttribute(Element element, String value) {
        String attribute = "data-title";
        element.setAttribute("data-title", value);
    }

    void setupTooltips() {
        JQueryTooltip.$((NodeList<Element>)this.getElement().querySelectorAll("[data-toggle='tooltip']")).tooltip();
    }

    void setupEventHandlers() {
        this.getEditButton().onclick = this.getOnEditAction();
        this.getSaveButton().onclick = this.getOnSaveAction();
        this.getCloseButton().onclick = this.getOnCloseAction();
        this.getArrow().onclick = this.getOnArrowClickAction();
        this.getInsertFieldAbove().onclick = this.getOnInsertFieldAboveAction();
        this.getInsertFieldBelow().onclick = this.getOnInsertFieldBelowAction();
        this.getInsertNestedField().onclick = this.getOnInsertNestedFieldAction();
        this.getRemoveButton().onclick = this.getOnRemoveButtonAction();
    }

    Element.OnclickCallbackFn getOnEditAction() {
        return e -> {
            this.presenter.enableEditMode();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnSaveAction() {
        return e -> {
            this.presenter.saveAndCloseEditMode();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnCloseAction() {
        return e -> {
            this.presenter.disableEditMode();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnArrowClickAction() {
        return e -> {
            this.presenter.expandOrCollapseSubTypes();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnInsertFieldAboveAction() {
        return e -> {
            this.presenter.insertFieldAbove();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnInsertFieldBelowAction() {
        return e -> {
            this.presenter.insertFieldBelow();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnInsertNestedFieldAction() {
        return e -> {
            this.presenter.insertNestedField();
            return true;
        };
    }

    Element.OnclickCallbackFn getOnRemoveButtonAction() {
        return e -> {
            this.presenter.remove();
            return true;
        };
    }

    private String list() {
        return this.translationService.format("DataTypeListItemView.List", new Object[0]);
    }

    Element getArrow() {
        return this.querySelector("arrow-button");
    }

    Element getNameText() {
        return this.querySelector("name-text");
    }

    HTMLInputElement getNameInput() {
        return (HTMLInputElement)this.querySelector(NAME_DATA_FIELD);
    }

    Element getType() {
        return this.querySelector("type");
    }

    Element getConstraintContainer() {
        return this.querySelector("constraint-container");
    }

    Element getListContainer() {
        return this.querySelector("list-container");
    }

    Element getListYes() {
        return this.querySelector("list-yes");
    }

    Element getEditButton() {
        return this.querySelector("edit-button");
    }

    Element getSaveButton() {
        return this.querySelector("save-button");
    }

    Element getCloseButton() {
        return this.querySelector("close-button");
    }

    Element getRemoveButton() {
        return this.querySelector("remove-button");
    }

    Element getInsertFieldAbove() {
        return this.querySelector("insert-field-above");
    }

    Element getInsertFieldBelow() {
        return this.querySelector("insert-field-below");
    }

    Element getInsertNestedField() {
        return this.querySelector("insert-nested-field");
    }

    Element getKebabMenu() {
        return this.querySelector("kebab-menu");
    }

    NodeList<Element> getLabels() {
        return this.getElement().querySelectorAll(".data-type-label");
    }

    Element querySelector(String fieldName) {
        return this.getElement().querySelector("[data-type-field=\"" + fieldName + "\"]");
    }
}

