/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;
import org.uberfire.client.views.pfly.selectpicker.ElementHelper;

@Templated
@ApplicationScoped
public class DataTypeListView
implements DataTypeList.View {
    @DataField(value="list-items")
    private final HTMLDivElement listItems;
    @DataField(value="placeholder")
    private final HTMLDivElement placeholder;
    @DataField(value="collapsed-description")
    private final HTMLDivElement collapsedDescription;
    @DataField(value="expanded-description")
    private final HTMLDivElement expandedDescription;
    @DataField(value="view-more")
    private final HTMLAnchorElement viewMore;
    @DataField(value="view-less")
    private final HTMLAnchorElement viewLess;
    @DataField(value="add-button")
    private final HTMLButtonElement addButton;
    @DataField(value="search-bar-container")
    private final HTMLDivElement searchBarContainer;
    @DataField(value="expand-all")
    private final HTMLAnchorElement expandAll;
    @DataField(value="collapse-all")
    private final HTMLAnchorElement collapseAll;
    @DataField(value="no-data-types-found")
    private final HTMLDivElement noDataTypesFound;
    @DataField(value="read-only-message")
    private final HTMLDivElement readOnlyMessage;
    @DataField(value="read-only-message-close-button")
    private final HTMLButtonElement readOnlyMessageCloseButton;
    private final ScrollHelper scrollHelper;
    private DataTypeList presenter;

    @Inject
    public DataTypeListView(HTMLDivElement listItems, HTMLDivElement collapsedDescription, HTMLDivElement expandedDescription, HTMLAnchorElement viewMore, HTMLAnchorElement viewLess, HTMLButtonElement addButton, HTMLDivElement placeholder, HTMLDivElement searchBarContainer, HTMLAnchorElement expandAll, HTMLAnchorElement collapseAll, HTMLDivElement noDataTypesFound, HTMLDivElement readOnlyMessage, HTMLButtonElement readOnlyMessageCloseButton, ScrollHelper scrollHelper) {
        this.listItems = listItems;
        this.collapsedDescription = collapsedDescription;
        this.expandedDescription = expandedDescription;
        this.viewMore = viewMore;
        this.viewLess = viewLess;
        this.addButton = addButton;
        this.placeholder = placeholder;
        this.searchBarContainer = searchBarContainer;
        this.expandAll = expandAll;
        this.collapseAll = collapseAll;
        this.noDataTypesFound = noDataTypesFound;
        this.readOnlyMessage = readOnlyMessage;
        this.readOnlyMessageCloseButton = readOnlyMessageCloseButton;
        this.scrollHelper = scrollHelper;
    }

    public void init(DataTypeList presenter) {
        this.presenter = presenter;
        this.setupSearchBar();
    }

    private void setupSearchBar() {
        this.searchBarContainer.appendChild((Node)this.presenter.getSearchBar().getElement());
    }

    @PostConstruct
    public void setup() {
        this.collapseDescription();
    }

    @Override
    public void setupListItems(List<DataTypeListItem> listItems) {
        RemoveHelper.removeChildren((Element)this.listItems);
        listItems.forEach(this::appendItem);
        this.showOrHideNoCustomItemsMessage();
    }

    @Override
    public void showOrHideNoCustomItemsMessage() {
        if (!this.hasCustomDataType()) {
            this.showPlaceHolder();
        } else {
            this.showListItems();
        }
    }

    boolean hasCustomDataType() {
        return !Objects.isNull(this.listItems.childNodes) && this.listItems.childNodes.length > 0.0;
    }

    @Override
    public void addSubItems(DataType dataType, List<DataTypeListItem> listItems) {
        Element parent = this.getDataTypeRow(dataType);
        for (DataTypeListItem item : listItems) {
            HTMLElement itemElement = item.getElement();
            this.hideItemElementIfParentIsCollapsed(itemElement, parent);
            ElementHelper.insertAfter((Node)itemElement, (Node)parent);
            parent = itemElement;
        }
        this.showArrowIconIfDataTypeHasChildren(dataType);
        this.showOrHideNoCustomItemsMessage();
    }

    @Override
    public void addSubItem(DataTypeListItem listItem) {
        this.appendItem(listItem);
        this.showOrHideNoCustomItemsMessage();
    }

    @EventHandler(value={"expand-all"})
    public void expandAll(ClickEvent e) {
        this.presenter.expandAll();
    }

    @EventHandler(value={"collapse-all"})
    public void collapseAll(ClickEvent e) {
        this.presenter.collapseAll();
    }

    @EventHandler(value={"add-button"})
    public void onAddClick(ClickEvent e) {
        this.scrollHelper.animatedScrollToBottom((Element)this.listItems);
        this.presenter.addDataType();
    }

    @EventHandler(value={"read-only-message-close-button"})
    public void onReadOnlyMessageCloseButtonClick(ClickEvent e) {
        HiddenHelper.hide((Element)this.readOnlyMessage);
    }

    void hideItemElementIfParentIsCollapsed(HTMLElement itemElement, Element parent) {
        boolean isCollapsedParent = this.isCollapsed(parent.querySelector("[data-type-field=\"arrow-button\"]"));
        boolean isHiddenParent = HiddenHelper.isHidden(parent);
        if (isCollapsedParent || isHiddenParent) {
            HiddenHelper.hide((Element)itemElement);
        } else {
            HiddenHelper.show((Element)itemElement);
        }
    }

    void showArrowIconIfDataTypeHasChildren(DataType dataType) {
        if (this.hasChildren(dataType)) {
            HiddenHelper.show(this.getDataTypeRow(dataType).querySelector("[data-type-field=\"arrow-button\"]"));
        } else {
            HiddenHelper.hide(this.getDataTypeRow(dataType).querySelector("[data-type-field=\"arrow-button\"]"));
        }
    }

    private boolean hasChildren(DataType dataType) {
        return this.listItems.querySelectorAll((String)new StringBuilder().append((String)"[data-parent-row-uuid=\"").append((String)dataType.getUUID()).append((String)"\"]").toString()).length > 0.0;
    }

    @Override
    public void removeItem(DataType dataType) {
        this.cleanSubTypes(dataType.getUUID());
        Optional<Element> dataTypeRow = Optional.ofNullable(this.getDataTypeRow(dataType));
        dataTypeRow.ifPresent(this::removeDataTypeRow);
        this.showOrHideNoCustomItemsMessage();
    }

    @Override
    public void cleanSubTypes(DataType dataType) {
        this.cleanSubTypes(dataType.getUUID());
    }

    void cleanSubTypes(String uuid) {
        String selector = "[data-parent-row-uuid=\"" + uuid + "\"]";
        NodeList subDataTypeRows = this.listItems.querySelectorAll(selector);
        int i = 0;
        while ((double)i < subDataTypeRows.length) {
            Element item = (Element)subDataTypeRows.getAt(i);
            if (item != null && item.parentNode != null) {
                this.cleanSubTypes(item.getAttribute("data-row-uuid"));
                this.removeDataTypeRow(item);
            }
            ++i;
        }
    }

    private void removeDataTypeRow(Element item) {
        this.presenter.removeItem(item.getAttribute("data-row-uuid"));
        ElementHelper.remove((Node)item);
    }

    @Override
    public void insertBelow(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getLastSubDataTypeElement(reference);
        ElementHelper.insertAfter((Node)listItem.getElement(), (Node)elementReference);
    }

    @Override
    public void insertAbove(DataTypeListItem listItem, DataType reference) {
        Element elementReference = this.getDataTypeRow(reference);
        ElementHelper.insertBefore((Node)listItem.getElement(), (Node)elementReference);
    }

    private boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    @EventHandler(value={"view-more"})
    public void onClickViewMore(ClickEvent event) {
        this.expandDescription();
    }

    @EventHandler(value={"view-less"})
    public void onClickViewLess(ClickEvent event) {
        this.collapseDescription();
    }

    private void appendItem(DataTypeListItem listItem) {
        this.listItems.appendChild((Node)listItem.getElement());
    }

    void expandDescription() {
        this.collapsedDescription.hidden = true;
        this.expandedDescription.hidden = false;
        this.viewLess.hidden = false;
        this.viewMore.hidden = true;
    }

    void collapseDescription() {
        this.collapsedDescription.hidden = false;
        this.expandedDescription.hidden = true;
        this.viewLess.hidden = true;
        this.viewMore.hidden = false;
    }

    Element getDataTypeRow(DataType dataType) {
        return this.listItems.querySelector("[data-row-uuid=\"" + dataType.getUUID() + "\"]");
    }

    Element getLastSubDataTypeElement(DataType reference) {
        return this.getLastSubDataTypeElement(this.getDataTypeRow(reference));
    }

    Element getLastSubDataTypeElement(Element element) {
        String parentUUID = element.getAttribute("data-row-uuid");
        String selector = "[data-parent-row-uuid=\"" + parentUUID + "\"]";
        NodeList nestedElements = this.listItems.querySelectorAll(selector);
        if (nestedElements.length == 0.0) {
            return element;
        }
        return this.getLastSubDataTypeElement((Element)nestedElements.getAt((int)nestedElements.length - 1));
    }

    @Override
    public void showNoDataTypesFound() {
        HiddenHelper.show((Element)this.noDataTypesFound);
        HiddenHelper.hide((Element)this.placeholder);
        HiddenHelper.hide((Element)this.listItems);
    }

    void showListItems() {
        HiddenHelper.hide((Element)this.noDataTypesFound);
        HiddenHelper.hide((Element)this.placeholder);
        HiddenHelper.show((Element)this.listItems);
    }

    void showPlaceHolder() {
        HiddenHelper.hide((Element)this.noDataTypesFound);
        HiddenHelper.show((Element)this.placeholder);
        HiddenHelper.hide((Element)this.listItems);
    }

    @Override
    public HTMLDivElement getListItems() {
        return this.listItems;
    }

    @Override
    public void showReadOnlyMessage(boolean show) {
        if (show) {
            HiddenHelper.show((Element)this.readOnlyMessage);
        } else {
            HiddenHelper.hide((Element)this.readOnlyMessage);
        }
    }
}

